% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{equal_discrete}
\alias{equal_discrete}
\title{Function Factory for Even Discretization Functions}
\usage{
equal_discrete(nlevels)
}
\arguments{
\item{nlevels}{number of levels to split continuous vector into}
}
\value{
function that makes a numeric vector discrete
}
\description{
Returns a function that converts a continuous numeric vector into an integer
vector with discrete levels.
}
\examples{
# test data
x <- 1:10

# create and apply function to split x into 2 discrete levels
split_2 <- equal_discrete(2)
split_2(x)

# create and apply function to split x into 5 discrete levels
split_5 <- equal_discrete(5)
split_5(x)
}
