% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_col.R
\name{grob_col}
\alias{grob_col}
\title{Grob Column}
\usage{
grob_col(
  ...,
  p = 1,
  width = NA_real_,
  aes_list = ga_list(),
  border = FALSE,
  border_aes_list = ga_list(),
  title = "",
  title_aes_list = ga_list(),
  title_p = 0.15,
  title_height = NA_real_,
  caption = "",
  caption_aes_list = ga_list(),
  caption_p = 0.15,
  caption_height = NA_real_,
  padding_p = 0.05,
  padding = NA_real_,
  hjust = 0.5,
  vjust = 0.5
)
}
\arguments{
\item{...}{Either the object to be converted to a grob, or a combination of 
grob-rows which need to be converted to sub-grobs.}

\item{p}{The numeric proportion of the width given to the outer grob-row which 
should be given to the grob-column outputted by this function. Defaults to 1.}

\item{width}{The numeric width of the grob-column in millimeters.

Overrides the \code{p} parameter.}

\item{aes_list}{The list outputted by \code{\link{ga_list}}, which controls
aesthetics object within the grob-column.}

\item{border}{A TRUE/FALSE argument corresponding to whether or not a border 
around the outputted grob-column is desired. Defaults to FALSE.}

\item{border_aes_list}{The list outputted by \code{\link{ga_list}}, which 
controls aesthetics of the borders. Only two aesthetics that can be tweaked
for borders are \code{border_color}, \code{border_width} and \code{border_sides}.

Ignored if \code{border} is set to FALSE.}

\item{title}{A character string which will be displayed as the title of the grob-column.}

\item{title_aes_list}{The list outputted by \code{\link{ga_list}}, which
controls aesthetics of the title of the grob-column.}

\item{title_p}{The numeric proportion of height within the grob-column which
will be used by the title grob.}

\item{title_height}{The numeric height in mm within the grob-column which will
be used by the title grob. Will override \code{title_p} if provided.}

\item{caption}{A character string which will be displayed as the caption of the grob-column.}

\item{caption_aes_list}{The list outputted by \code{\link{ga_list}}, which
controls aesthetics of the caption of the grob-column.}

\item{caption_p}{The numeric proportion of height within the grob-column
which will be used by the caption grob.}

\item{caption_height}{The numeric height in mm within the grob-column which will
be used by the caption grob. Will override \code{caption_p} if provided.}

\item{padding_p}{The proportion of the minimum of the height and width which
will be used for the padding around the edge of the grob-column.

Overridden by any numeric value provided in the \code{padding} parameter.}

\item{padding}{The numeric amount of padding around the edge of the grob-column in millimeters.

Overrides the \code{padding_p} parameter.}

\item{hjust}{A numeric value which will determine the alignment of the grob
horizontally within its designated area. A value of 0 means moving the grob
all the way to the left, a value of 1 means moving the grob all the way to
the right and a value of 0.5 means keeping the grob in the middle.
Defaults to 0.5.

The grob-column is moved around within its padding, so if
there is no padding, then \code{hjust} will be rendered useless.}

\item{vjust}{A numeric value which will determine the alignment of the grob 
vertically within its designated area. A value of 0 means moving the grob all
the way to the bottom, a value of 1 means moving the grob all the way to the
top and a value of 0.5 means keeping the grob in the middle. Defaults to 0.5.

The grob-column is moved around within its padding, so if there is no padding,
then \code{vjust} will be rendered useless.}
}
\value{
An R6 class object containing all the information needed to create the grob-column.
}
\description{
The grob-column function where an object is converted a grob. Works within \code{\link{grob_row}}.
}
\examples{

grob_col(
  "grob-column",
  aes_list = ga_list(
    text_color = "red",
    background_color = "gray90"
    )
  ) \%>\%
 view_grob(100, 100)

}
