% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/System.R
\name{System}
\alias{System}
\title{FUNCTION_TITLE}
\usage{
System(
  yr,
  ordinary_tax_thresholds = NULL,
  ordinary_tax_rates = NULL,
  medicare_levy_taper = NULL,
  medicare_levy_rate = NULL,
  medicare_levy_lower_threshold = NULL,
  medicare_levy_lower_sapto_threshold = NULL,
  medicare_levy_lower_family_threshold = NULL,
  medicare_levy_lower_family_sapto_threshold = NULL,
  medicare_levy_lower_up_for_each_child = NULL,
  medicare_levy_upper_sapto_threshold = NULL,
  medicare_levy_upper_family_threshold = NULL,
  medicare_levy_upper_family_sapto_threshold = NULL,
  medicare_levy_upper_threshold = NULL,
  Offsets = NULL,
  sapto_max_offset = NULL,
  sapto_lower_threshold = NULL,
  sapto_taper = NULL,
  sapto_max_offset_married = NULL,
  sapto_lower_threshold_married = NULL,
  sapto_taper_married = NULL,
  sapto_max_offset_illness = NULL,
  sapto_lower_threshold_illness = NULL,
  sapto_pension_age = NULL,
  fix = 0L
)
}
\arguments{
\item{yr}{\code{integer(1)} A year.}

\item{ordinary_tax_thresholds}{A numeric vector specifying the lower bounds of the brackets for "ordinary tax" as defined by the Regulations.
The first element should be zero if there is a tax-free threshold.}

\item{ordinary_tax_rates}{The marginal rates of ordinary tax. The first element should be zero if there is a tax-free threshold. 
Since the temporary budget repair levy was imposed on a discrete tax bracket when it applied, it is not included in this function.}

\item{medicare_levy_taper}{The taper that applies between the \code{_lower} and \code{_upper} thresholds.}

\item{medicare_levy_rate}{The ordinary rate of the Medicare levy for taxable incomes above \code{medicare_levy_upper_threshold}.}

\item{medicare_levy_lower_threshold}{Minimum taxable income at which the Medicare levy will be applied.}

\item{medicare_levy_lower_sapto_threshold, medicare_levy_upper_sapto_threshold}{The equivalent values for SAPTO-eligible individuals (not families).}

\item{medicare_levy_lower_family_threshold, medicare_levy_upper_family_threshold}{The equivalent values for families.}

\item{medicare_levy_lower_family_sapto_threshold, medicare_levy_upper_family_sapto_threshold}{The equivalent values for SAPTO-eligible individuals in a family.}

\item{medicare_levy_lower_up_for_each_child}{The amount to add to the \code{_family_threshold}s for each dependant child.}

\item{medicare_levy_upper_threshold}{Minimum taxable income at which the Medicare levy will be applied at the full Medicare levy rate (2\% in 2015-16). Between this threshold and the \code{medicare_levy_lower_threshold}, a tapered rate applies, starting from zero and climbing to \code{medicare_levy_rate}.}

\item{Offsets}{List of offsets created by \code{set_offsets}.}

\item{sapto_max_offset}{The maximum offset available through SAPTO.}

\item{sapto_lower_threshold}{The threshold at which SAPTO begins to reduce (from \code{sapto_max_offset}).}

\item{sapto_taper}{The taper rate beyond \code{sapto_lower_threshold}.}

\item{sapto_max_offset_married, sapto_lower_threshold_married, sapto_taper_married, sapto_lower_threshold_illness, sapto_max_offset_illness}{As above,
but applied to members of a couple.}

\item{sapto_pension_age}{The age at and above which the SAPTO is to apply.}

\item{fix}{\code{integer(1)} If \code{0L}, the default, an error will be emitted if
parameters are inconsistent; if \code{1L}, inconsistencies will be fixed.}
}
\description{
FUNCTION_DESCRIPTION
}
\details{
A list describing a tax system
}
