% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checks.R
\name{check_partial_matrix_and_graph}
\alias{check_partial_matrix_and_graph}
\title{Check input graph and partial matrix}
\usage{
check_partial_matrix_and_graph(M, graph = NULL, graph_type = "general")
}
\arguments{
\item{M}{A partial matrix or a vector of entries corresponding to the edges of \code{graph}}

\item{graph}{A graph object or \code{NULL} if the graph structure is implied by the \code{NA} structure of \code{M}}

\item{graph_type}{Passed to \code{\link[=check_graph]{check_graph()}}.}
}
\value{
A list consisting of
\item{\code{matrix}}{The matrix given as input or implied by the input}
\item{\code{graph}}{The graph given as input or implied by the input}
Throws an error if the input is not valid.
}
\description{
Checks and converts the partial matrix and graph given for a
HR graphical model.
}
\seealso{
Other input validation functions:
\code{\link{checkGamma}()},
\code{\link{check_graph}()},
\code{\link{ensure_matrix_symmetry}()}
}
\concept{inputChecks}
\keyword{internal}
