% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_capacity.R
\name{graphab_capacity}
\alias{graphab_capacity}
\title{Computes custom capacities of patches in the Graphab project}
\usage{
graphab_capacity(
  proj_name,
  mode = "area",
  patch_codes = NULL,
  exp = NULL,
  ext_file = NULL,
  thr = NULL,
  linkset = NULL,
  codes = NULL,
  cost_conv = FALSE,
  weight = FALSE,
  proj_path = NULL,
  alloc_ram = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is. It can be created with \code{\link{graphab_project}}}

\item{mode}{A character string indicating the way capacities are
computed. It must be either:\itemize{
\item{\code{mode='area'}(default): The capacity of the patches is computed
as the area of each habitat patch. The argument \code{exp} makes it
possible to raise area to a power given by an exposant.}
\item{\code{mode='ext_file'}: The capacity of the patches is given by an
external .csv file. See argument \code{ext_file} below.}
\item{\code{mode='neigh'}: The capacity is computed depending on the
neighbouring raster cells from each habitat patch. The number of cells
with a value given by \code{codes} argument is summed up to the
distance \code{thr}. This number can be weighted according to the
\code{weight} argument.}
}}

\item{patch_codes}{(optional, default=NULL) An integer value or vector
specifying the codes corresponding to the habitat pixel whose corresponding
patches are included to compute the capacity as the area of the habitat
when \code{mode='area'}. Patches corresponding to other initial habitat
codes are weighted by 0.}

\item{exp}{An integer value specifying the power to which patch area are
raised when \code{mode='area'}. When not specified, \code{exp=1} by default.}

\item{ext_file}{A character string specifying the name of the .csv file in
which patch capacities are stored. It must be located either in the working
directory or in the directory defined by \code{proj_path}. It must have
as many rows as there are patches in the project and its column names
must include 'Id' and 'Capacity'. The 'Id' column must correspond to the
patch ID in the 'patches' layer (see \code{\link{get_graphab_metric}}).
The 'Capacity' column must contain the corresponding patch capacities to
assign each patch.}

\item{thr}{(optional, default=NULL) An integer or numeric value indicating
the maximum distance in cost distance units (except when
\code{cost_conv = TRUE}) at which cells are considered for computing the
capacity when \code{mode='neigh'}.}

\item{linkset}{(optional, default=NULL) A character string indicating the
name of the link set used to take distance into account when computing
the capacity. Only used when \code{mode='neigh'}. Link sets can be
created with \code{\link{graphab_link}}.}

\item{codes}{An integer value or a vector of integer values specifying the
codes of the raster cells taken into account when computing the capacity in
the neighbourhood of the patches, when \code{mode='neigh'}.}

\item{cost_conv}{FALSE (default) or TRUE. Logical indicating whether numeric
\code{thr} values are converted from cost-distance into Euclidean distance
using a log-log linear regression. See also \code{\link{convert_cd}}
function. Only used when \code{mode='neigh'}.}

\item{weight}{A logical indicating whether the cells are weighted by a
weight decreasing with the distance from the patches (TRUE) or not (FALSE).
The weights follow a negative exponential decline such that
wi = exp(-alpha*di), where wi is the weight of cell i, di its distance from
the patch and alpha a parameter determined such that wi = 0.05 when di = thr.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}
}
\description{
The function computes custom capacities of patches
in the Graphab project
}
\details{
See more information in Graphab 2.8 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.8-en.pdf}
Be careful, when capacity has been changed. The last changes are taken into
account for subsequent calculations in a project.
}
\examples{
\dontrun{
graphab_capacity(proj_name = "grphb_ex",
                 mode = "area")
}
}
\author{
P. Savary
}
