% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLong.R
\name{plot.LongData}
\alias{plot.LongData}
\title{Plot a Long Data Frame}
\usage{
\method{plot}{LongData}(x, plotIds, by, ID, DV, ...)
}
\arguments{
\item{x}{longitudinal data frame of class 'LongData'.}

\item{plotIds}{vector of IDs for which the data should be printed. Can be left empty. Then 5 IDs are picked randomly.}

\item{by}{label of the variable on the x-axis. Can be left empty.}

\item{ID}{label of the ID column. Can be left empty.}

\item{DV}{label of the variable on the y-axis. Can be left empty.}

\item{...}{additional parameters (currently not used).}
}
\value{
a fitted Gaussian process panel model, which is an object of class 'GPPM'
}
\description{
This function is used to plot data from class 'LongData' as it is returned by \code{\link{getData}} \code{\link{simulate.GPPM}}.
}
\examples{
data("demoLGCM")
plot(demoLGCM, plotIds = c(1, 2, 3))
plot(demoLGCM) # five random ids
}
