% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{predict.LMCAnisCompo}
\alias{predict.LMCAnisCompo}
\title{Compute model variogram values

Evaluate the variogram model provided at some lag vectors}
\usage{
\method{predict}{LMCAnisCompo}(object, newdata, ...)
}
\arguments{
\item{object}{variogram model}

\item{newdata}{matrix or data.frame of lag vectors}

\item{...}{extra arguments for generic compatbility}
}
\value{
an array of dimension (nr of lags, D, D) with D the number of variables in the model.
}
\description{
Compute model variogram values

Evaluate the variogram model provided at some lag vectors
}
\examples{
data("jura", package="gstat")
Zc = compositions::acomp(jura.pred[,7:9])
lrmd = LMCAnisCompo(Zc, models=c("nugget", "sph"), azimuths=c(0,45))
predict(lrmd, outer(0:5, c(0,1)))
}
