% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R,
%   R/compositionsCompatibility.R
\name{as.logratioVariogram.gstatVariogram}
\alias{as.logratioVariogram.gstatVariogram}
\alias{as.logratioVariogram}
\alias{as.logratioVariogram.logratioVariogram}
\alias{as.logratioVariogram.gmEVario}
\title{Recast empirical variogram to format logratioVariogram}
\usage{
\method{as.logratioVariogram}{gstatVariogram}(
  vgemp,
  V = NULL,
  tol = 1e-12,
  orignames = NULL,
  symmetrize = FALSE,
  ...
)

as.logratioVariogram(vgemp, ...)

\method{as.logratioVariogram}{logratioVariogram}(vgemp, ...)

\method{as.logratioVariogram}{gmEVario}(vgemp, ...)
}
\arguments{
\item{vgemp}{empirical variogram}

\item{V}{matrix or name of the logratio transformation used}

\item{tol}{tolerance for generalized inverse (eventually for clr case; defaults to 1e-12)}

\item{orignames}{names of the original component (default NULL)}

\item{symmetrize}{do you want a whole circle of directions? (default FALSE)}

\item{...}{parameters for generic functionality}
}
\value{
the same model in the new format.
}
\description{
Recast an empirical compositional variogram of any sort to a variation-variogram of class
"logratioVariogram".
}
\section{Methods (by class)}{
\itemize{
\item \code{gstatVariogram}: method for gstatVariogram objects

\item \code{logratioVariogram}: identity method

\item \code{gmEVario}: method for gmEVario objects (not yet available)
}}

