% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anamorphosis.R
\name{anaForward}
\alias{anaForward}
\title{Forward gaussian anamorphosis
forward transformation to multivariate gaussian scores}
\usage{
anaForward(
  x,
  Y,
  sigma0,
  sigma1 = 1 + sigma0,
  steps = 30,
  plt = FALSE,
  sphere = TRUE,
  weights = NULL
)
}
\arguments{
\item{x}{points to be transformed (a matrix)}

\item{Y}{node points defining the transformation (another matrix, same nr. of columns as \code{x})}

\item{sigma0}{starting spread of the kernels}

\item{sigma1}{final spread of the kernels}

\item{steps}{number of steps to linearize the transform (default 30 is good)}

\item{plt}{boolean, do you want to get a plot of the transformation?}

\item{sphere}{boolean, should the data be pre-Y-spherified first? defaults to true}

\item{weights}{vector of weights for all computations, length must be equal
to number of rows of \code{x}}
}
\value{
a matrix with the gaussian scores; same dimensions of \code{x}
}
\description{
Forward gaussian anamorphosis
forward transformation to multivariate gaussian scores
}
\examples{
data("jura", package="gstat")
Y = jura.pred[,c(10,12,13)]
plot(compositions::acomp(Y))
Ylr = compositions::alr(Y)
plot(Ylr)
z = anaForward(x=Ylr, Y=Ylr, sigma0=0.1)
plot(z, asp=1)
shapiro.test(z[,1])
shapiro.test(z[,2])
}
\seealso{
\code{\link[=ana]{ana()}} for defining a function that carries over the transformation
(by means of a closure), \code{\link[=anaBackward]{anaBackward()}} for the explicit back-transformation,
\code{\link[=sphTrans]{sphTrans()}} for defining a function that carries over the spherification of the data
}
\author{
K. Gerald van den Boogaart, Raimon Tolosana-Delgado
}
