% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_place.R
\docType{data}
\name{geom_places}
\alias{geom_places}
\alias{StatPlaces}
\alias{stat_places}
\alias{GeomPlaces}
\title{Emphasize Populated Regions of a Map with greyed out Places}
\usage{
geom_places(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  state = NULL,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_places(
  mapping = NULL,
  data = NULL,
  geom = ggplot2::GeomSf,
  position = "identity",
  na.rm = FALSE,
  state = NULL,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{data}{The data to be displayed in this layer}

\item{position}{Position adjustment}

\item{na.rm}{if \code{TRUE}, will silently remove missing values from calculations}

\item{state}{state to use. Guesses based on overlap if not provided.}

\item{show.legend}{Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{...}{Passed onto the underlying geoms.}

\item{geom}{The geometric object to use display the data}
}
\value{
a \code{ggproto} object
}
\description{
Identifies relevant census places and plots them.
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(group = cd_2020)) +
  geom_district() +
  stat_places(state = 'OR') +
  theme_map()
ggplot(oregon, aes(group = cd_2020)) +
  geom_district() +
  geom_places(state = 'OR') +
  theme_map()

}
\concept{geoms}
\keyword{datasets}
