% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-shape.R
\name{scale_shape}
\alias{scale_shape}
\alias{scale_shape_binned}
\alias{scale_shape_discrete}
\alias{scale_shape_ordinal}
\alias{scale_shape_continuous}
\title{Scales for shapes, aka glyphs}
\usage{
scale_shape(name = waiver(), ..., solid = NULL, aesthetics = "shape")

scale_shape_binned(name = waiver(), ..., solid = TRUE, aesthetics = "shape")
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{
  Arguments passed on to \code{\link[=discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{solid}{Should the shapes be solid, \code{TRUE}, or hollow,
\code{FALSE}?}

\item{aesthetics}{The names of the aesthetics that this scale works with.}
}
\description{
\code{scale_shape()} maps discrete variables to six easily discernible shapes.
If you have more than six levels, you will get a warning message, and the
seventh and subsequent levels will not appear on the plot. Use
\code{\link[=scale_shape_manual]{scale_shape_manual()}} to supply your own values. You can not map
a continuous variable to shape unless \code{scale_shape_binned()} is used. Still,
as shape has no inherent order, this use is not advised.
}
\details{
Shapes can be referred to by number or name. Shapes in [0, 20] do not
support a fill aesthetic, whereas shapes in [21, 25] do.

\if{html}{\figure{shape_table.svg}{All shapes by number and name}}
\if{latex}{\figure{shape_table.pdf}}
}
\examples{
set.seed(596)
dsmall <- diamonds[sample(nrow(diamonds), 100), ]

(d <- ggplot(dsmall, aes(carat, price)) + geom_point(aes(shape = cut)))
d + scale_shape(solid = TRUE) # the default
d + scale_shape(solid = FALSE)
d + scale_shape(name = "Cut of diamond")

# To change order of levels, change order of
# underlying factor
levels(dsmall$cut) <- c("Fair", "Good", "Very Good", "Premium", "Ideal")

# Need to recreate plot to pick up new data
ggplot(dsmall, aes(price, carat)) + geom_point(aes(shape = cut))

# Show a list of available shapes
df_shapes <- data.frame(shape = 0:24)
ggplot(df_shapes, aes(0, 0, shape = shape)) +
  geom_point(aes(shape = shape), size = 5, fill = 'red') +
  scale_shape_identity() +
  facet_wrap(~shape) +
  theme_void()
}
\seealso{
The documentation for \link[=aes_linetype_size_shape]{differentiation related aesthetics}.

Other shape scales: \code{\link[=scale_shape_manual]{scale_shape_manual()}}, \code{\link[=scale_shape_identity]{scale_shape_identity()}}.

The \href{https://ggplot2-book.org/scales-other#sec-scale-shape}{shape section} of the online ggplot2 book.
}
