% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-fixed.R
\name{coord_fixed}
\alias{coord_fixed}
\alias{coord_equal}
\title{Cartesian coordinates with fixed "aspect ratio"}
\usage{
coord_fixed(ratio = 1, ...)
}
\arguments{
\item{ratio}{aspect ratio, expressed as \code{y / x}. Can be \code{NULL} (default) to
not use an aspect ratio. Using \code{1} ensures that one unit on the x-axis
is the same length as one unit on the y-axis. Ratios higher than one make
units on the y-axis longer than units on the x-axis, and vice versa.}

\item{...}{
  Arguments passed on to \code{\link[=coord_cartesian]{coord_cartesian}}
  \describe{
    \item{\code{xlim,ylim}}{Limits for the x and y axes.}
    \item{\code{expand}}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.
Giving a logical vector will separately control the expansion for the four
directions (top, left, bottom and right). The \code{expand} argument will be
recycled to length 4 if necessary. Alternatively, can be a named logical
vector to control a single direction, e.g. \code{expand = c(bottom = FALSE)}.}
    \item{\code{default}}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}
    \item{\code{clip}}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
    \item{\code{reverse}}{A string giving which directions to reverse. \code{"none"}
(default) keeps directions as is. \code{"x"} and \code{"y"} can be used to reverse
their respective directions. \code{"xy"} can be used to reverse both
directions.}
  }}
}
\description{
A fixed scale coordinate system forces a specified ratio between the
physical representation of data units on the axes. The ratio represents the
number of units on the y-axis equivalent to one unit on the x-axis. The
default, \code{ratio = 1}, ensures that one unit on the x-axis is the same
length as one unit on the y-axis. Ratios higher than one make units on the
y axis longer than units on the x-axis, and vice versa. This is similar to
\code{\link[MASS:eqscplot]{MASS::eqscplot()}}, but it works for all types of graphics.
}
\examples{
# ensures that the ranges of axes are equal to the specified ratio by
# adjusting the plot aspect ratio

p <- ggplot(mtcars, aes(mpg, wt)) + geom_point()
p + coord_fixed(ratio = 1)
p + coord_fixed(ratio = 5)
p + coord_fixed(ratio = 1/5)
p + coord_fixed(xlim = c(15, 30))

# Resize the plot to see that the specified aspect ratio is maintained
}
