% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_errorbar_table.R
\name{pathway_errorbar_table}
\alias{pathway_errorbar_table}
\title{Generate Abundance Statistics Table for Pathway Analysis}
\usage{
pathway_errorbar_table(
  abundance,
  daa_results_df,
  Group,
  ko_to_kegg = FALSE,
  p_values_threshold = 0.05,
  select = NULL,
  max_features = 30,
  metadata = NULL,
  sample_col = "sample_name"
)
}
\arguments{
\item{abundance}{A data frame or matrix containing predicted functional 
pathway abundance, with pathways/features as rows and samples as 
columns. The column names should match the sample names in metadata.}

\item{daa_results_df}{A data frame containing differential abundance 
analysis results from pathway_daa function. Must contain columns: 
feature, group1, group2, p_adjust.}

\item{Group}{A vector containing group assignments for each sample in the
same order as the columns in abundance matrix. Alternatively, if
metadata is provided, this should match the order of samples in metadata.}

\item{ko_to_kegg}{Logical value indicating whether to use KO to KEGG 
conversion. Default is FALSE.}

\item{p_values_threshold}{Numeric value for p-value threshold to filter 
significant features. Default is 0.05.}

\item{select}{Character vector of specific features to include. If NULL, 
all significant features are included.}

\item{max_features}{Maximum number of features to include in the table.
Default is 30.}

\item{metadata}{Optional data frame containing sample metadata. If provided,
the Group vector will be reordered to match the abundance column order.}

\item{sample_col}{Character string specifying the column name in metadata
that contains sample identifiers. Default is "sample_name".}
}
\value{
A data frame containing the following columns:
\itemize{
  \item \code{feature}: Feature/pathway identifier
  \item \code{group1}: Reference group name
  \item \code{group2}: Comparison group name
  \item \code{mean_rel_abundance_group1}: Mean relative abundance for group1
  \item \code{sd_rel_abundance_group1}: Standard deviation of relative
        abundance for group1
  \item \code{mean_rel_abundance_group2}: Mean relative abundance for group2
  \item \code{sd_rel_abundance_group2}: Standard deviation of relative
        abundance for group2
  \item \code{log2_fold_change}: Log2 fold change (group2/group1)
  \item \code{p_adjust}: Adjusted p-value from differential analysis
  \item Additional annotation columns (e.g., \code{description},
        \code{pathway_name}, \code{pathway_class}) if present in the input
        daa_results_df
}
}
\description{
This function generates a table containing mean relative abundance, 
standard deviation, and log2 fold change statistics for pathways, 
similar to the data used in pathway_errorbar plots but returned as a 
data frame instead of a plot.
}
\examples{
\dontrun{
# Load example data
data("ko_abundance")
data("metadata")

# Convert KO abundance to KEGG pathways
kegg_abundance <- ko2kegg_abundance(data = ko_abundance)

# Perform differential abundance analysis
daa_results_df <- pathway_daa(
  abundance = kegg_abundance,
  metadata = metadata,
  group = "Environment",
  daa_method = "ALDEx2"
)

# Filter for specific method
daa_sub_method_results_df <- daa_results_df[
  daa_results_df$method == "ALDEx2_Welch's t test", 
]

# Annotate results
daa_annotated_sub_method_results_df <- pathway_annotation(
  pathway = "KO",
  daa_results_df = daa_sub_method_results_df,
  ko_to_kegg = TRUE
)

# Generate abundance statistics table
abundance_stats_table <- pathway_errorbar_table(
  abundance = kegg_abundance,
  daa_results_df = daa_annotated_sub_method_results_df,
  Group = metadata$Environment,
  ko_to_kegg = TRUE,
  p_values_threshold = 0.05
)

# View the results
head(abundance_stats_table)
}

}
