% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeHelpers.R
\name{countOffspring}
\alias{countOffspring}
\title{Count offspring of each individual}
\usage{
countOffspring(ped, personID = "ID", momID = "momID", dadID = "dadID")
}
\arguments{
\item{ped}{A data frame containing the pedigree information}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}
}
\value{
A data frame with an additional column, offspring,
   that contains the number of offspring for each individual
}
\description{
Count offspring of each individual
}
\examples{
library(BGmisc)
data("potter")
countOffspring(potter,
  personID = "personID",
  momID = "momID", dadID = "dadID"
)

}
