% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-center.r
\name{stat_center}
\alias{stat_center}
\alias{stat_star}
\title{Centers and spreads for bivariate data}
\usage{
stat_center(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  fun.data = NULL,
  fun = NULL,
  fun.center = NULL,
  fun.min = NULL,
  fun.max = NULL,
  fun.ord = NULL,
  fun.args = list()
)

stat_star(
  mapping = NULL,
  data = NULL,
  geom = "segment",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  fun.data = NULL,
  fun = NULL,
  fun.center = NULL,
  fun.ord = NULL,
  fun.args = list()
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{fun.data}{A function that is given the complete data and should
return a data frame with variables \code{ymin}, \code{y}, and \code{ymax}.}

\item{fun.center}{Deprecated alias to \code{fun}.}

\item{fun.min, fun, fun.max}{Alternatively, supply three individual
functions that are each passed a vector of values and should return a
single number.}

\item{fun.ord}{Alternatively to the \code{\link[ggplot2:stat_summary]{ggplot2::stat_summary_bin()}} parameters,
supply a summary function that takes a matrix as input and returns a named
column summary vector. Overridden by \code{fun.data} and \code{fun}, cannot be used
together with \code{fun.min} and \code{fun.max}.}

\item{fun.args}{Optional additional arguments passed on to the functions.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Centers and spreads for bivariate data
}
\section{Multidimensional position aesthetics}{

This statistical transformation is compatible with the convenience function
\code{\link[=aes_coord]{aes_coord()}}.

Some transformations (e.g. \code{\link[=stat_center]{stat_center()}}) commute with projection to the
lower (1 or 2)-dimensional biplot space. If they detect aesthetics of the
form \verb{..coord[0-9]+}, then \code{..coord1} and \code{..coord2} are converted to \code{x} and
\code{y} while any remaining are ignored.

Other transformations (e.g. \code{\link[=stat_spantree]{stat_spantree()}}) yield different results in a
lower-dimensional biplot when they are computed before versus after
projection. If the stat layer detects these aesthetics, then the
transformation is performed before projection, and the results in the first
two dimensions are returned as \code{x} and \code{y}.

A small number of transformations (\code{\link[=stat_rule]{stat_rule()}}) are incompatible with
these aesthetics but will accept \code{aes_coord()} without warning.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.
\describe{
\item{\verb{xmin,ymin,xmax,ymax}}{results of \verb{fun.min,fun.max} applied to \verb{x,y}}
}
}

\examples{
ggplot(mpg, aes(x = displ, y = cty, shape = drv)) +
  geom_point() +
  stat_center(fun = "median", size = 5, alpha = .5)

ggplot(mpg, aes(x = displ, y = cty, shape = drv, linetype = drv)) +
  stat_center(size = 3) +
  stat_star()
}
\seealso{
Other stat layers: 
\code{\link{stat_bagplot}()},
\code{\link{stat_chull}()},
\code{\link{stat_cone}()},
\code{\link{stat_depth}()},
\code{\link{stat_rule}()},
\code{\link{stat_scale}()},
\code{\link{stat_spantree}()}
}
\concept{stat layers}
