% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_symmetric.R
\name{scale_y_symmetric}
\alias{scale_y_symmetric}
\title{Symmetric y continuous scale}
\usage{
scale_y_symmetric(
  data = NULL,
  y = NULL,
  ...,
  breaks = NULL,
  breaks_n = 6,
  expand = NULL,
  expand_limits = NULL,
  labels = NULL,
  position = "left",
  sec_axis = ggplot2::waiver(),
  transform = "identity",
  symmetric = TRUE
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{y}{An unquoted variable.}

\item{...}{Provided to force user argument naming etc.}

\item{breaks}{A \verb{scales::breaks_*} function (e.g. \verb{scales::breaks_*()}), or a vector of breaks.}

\item{breaks_n}{If \code{breaks = NULL}, the desired number of breaks.}

\item{expand}{Padding to the limits with the \code{\link[ggplot2:expansion]{ggplot2::expansion()}} function, or a vector of length 2 (e.g. \code{c(0, 0)}).}

\item{expand_limits}{Any values that the limits should encompass (e.g. \code{0}).}

\item{labels}{A function that takes the breaks as inputs (e.g. \verb{\\(x) stringr::str_to_sentence(x)} or \verb{scales::label_*()}), or a vector of labels.}

\item{position}{The position of the axis (i.e. \code{"left"}, \code{"right"}, \code{"bottom"} or \code{"top"}).}

\item{sec_axis}{A secondary axis created with \code{\link[ggplot2:sec_axis]{ggplot2::sec_axis()}} or \code{\link[ggplot2:sec_axis]{ggplot2::dup_axis()}}.}

\item{transform}{A transformation object (e.g. \code{\link[scales:transform_log]{scales::transform_log10()}}) or character string of this minus the \code{transform_} prefix (e.g. \code{"log10"}).}

\item{symmetric}{\code{TRUE} or \code{FALSE} of whether a symmetric scale.}
}
\value{
A ggplot2 continuous y scale.
}
\description{
Create a symmetric continuous y scale for ggplot2 plots.
The scale ensures that limits set to the range of breaks with zero expand (where \code{symmetric = TRUE}).
Note this scale should only be used in plots with geoms with \code{stat = "identity"}.
Symmetric y continuous scale
}
\examples{
library(ggplot2)
library(dplyr)
library(palmerpenguins)

set_blanket()

penguins |>
  ggplot() +
  geom_point(aes(x = flipper_length_mm, y = body_mass_g, colour = species)) +
  scale_y_symmetric(penguins, body_mass_g) +
  theme(axis.line.y = element_blank()) +
  theme(axis.ticks.y = element_blank()) +
  theme(panel.grid.major.x = element_blank()) +
  coord_cartesian(clip = "off") +
  labs(x = "Flipper length mm", y = "Body mass g", colour = "Species")

}
