% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_specific_utils.R
\name{mutinfo}
\alias{mutinfo}
\title{Compute Mutual Information}
\usage{
mutinfo(features, target, return_colnames = FALSE)
}
\arguments{
\item{features}{A data frame of features. These will be discretized using the "equalfreq" method
(see \code{\link[infotheo:discretize]{infotheo::discretize()}}).}

\item{target}{A vector (character or factor) representing the variable to compute mutual information with.}

\item{return_colnames}{Logical; if \code{TRUE}, returns the column names from \code{features} ordered by their
mutual information with \code{target} (highest to lowest). If \code{FALSE}, returns mutual information values. (default: \code{FALSE})}
}
\value{
If \code{return_colnames = FALSE}, a named numeric vector of mutual information scores is returned (one for each column in \code{features}), sorted in descending order.
The names of the vector correspond to the column names of \code{features}.
If \code{return_colnames = TRUE}, only the ordered column names of \code{features} are returned.
}
\description{
Computes mutual information between each feature in the \code{features} data frame and the \code{target} vector.
The features are discretized using the "equalfreq" method from \code{\link[infotheo:discretize]{infotheo::discretize()}}.
}
\examples{
data(iris)
# Compute mutual information scores
mutinfo(iris[1:4], iris[[5]])

# Get column names ordered by mutual information with target column (most mutual info first)
mutinfo(iris[1:4], iris[[5]], return_colnames = TRUE)

}
