% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostan_fit-methods.R
\name{as.matrix.geostan_fit}
\alias{as.matrix.geostan_fit}
\alias{as.data.frame.geostan_fit}
\alias{as.array.geostan_fit}
\title{Extract samples from a fitted model}
\usage{
\method{as.matrix}{geostan_fit}(x, ...)

\method{as.data.frame}{geostan_fit}(x, ...)

\method{as.array}{geostan_fit}(x, ...)
}
\arguments{
\item{x}{A fitted model object of class \code{geostan_fit}.}

\item{...}{Further arguments passed to \code{rstan} methods for for \code{as.data.frame}, \code{as.matrix}, or \code{as.array}}
}
\value{
A matrix, data frame, or array of MCMC samples is returned.
}
\description{
Extract samples from the joint posterior distribution of parameters.
}
\examples{
data(georgia)
A <- shape2mat(georgia, "B")

fit <- stan_glm(deaths.male ~ offset(log(pop.at.risk.male)),
                C = A,
                data = georgia,
                family = poisson(),
                chains = 1, iter = 600) # for speed only


s <- as.matrix(fit)
dim(s)

a <- as.matrix(fit, pars = "intercept")
dim(a)

# Or extract the stanfit object
S <- fit$stanfit
print(S, pars = "intercept")
samples <- as.matrix(S)
dim(samples)
}
