#' Internal function to `collapse()` for `type = "doi"`
#' @importFrom rlang abort
#' @importFrom stringr str_split
#' @noRd
#' @keywords Internal
collapse_occurrences_doi <- function(.query, error_call = caller_env()){
  if(is.null(.query$filter)){
    abort("A DOI must be specified using `filter(doi == \"my-doi-here\")`.", 
          call = error_call)
  }
  
  if(is.null(.query$filter$variable) && .query$filter$variable != "doi"){
    abort("No DOI has been supplied.", 
          call = error_call)
  }
  
  if(pour("atlas", "acronym") != "ALA"){
    bullets <- c(
      "DOI downloads not supported by selected atlas.",
      i = "`request_data(type = \"occurrences-doi\")` has only been implemented for ALA."
    )
    abort(bullets, 
          call = error_call)    
  }
  
  doi <- .query$filter$value[[1]]
  
  # remove "https://" if present
  if (grepl("^http://doi.org/", doi)) {
    doi <- sub("^https://doi.org/", "", doi)
  }
  
  # extract useful part of DOI
  doi_str <- stringr::str_split(doi, "ala.")[[1]][2]
  if (is.na(doi_str)) {
    bullets <- c(
      "DOI has not been generated by the ALA.",
      i = "DOIs created by the ALA have a prefix of 10.26197/ala."
    )
    abort(bullets, call = error_call)
  }
  
  result <- list(
    type = "data/occurrences-doi",
    url = url_lookup("data/occurrences-doi", doi_string = doi_str),
    headers = build_headers(),
    download = TRUE)
  class(result) <- "data_query"
  return(result)
}
