% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api-reset.R
\name{reset}
\alias{reset}
\title{Reset a finished, failed, canceled, or interrupted future to a lazy future}
\usage{
reset(x, ...)
}
\arguments{
\item{x}{A Future.}

\item{\ldots}{Not used.}
}
\value{
\code{reset()} returns a lazy, vanilla \link{Future} that can be relaunched.
Resetting a running future results in a \link{FutureError}.
}
\description{
A future that has successfully completed, \link[=cancel]{canceled}, interrupted,
or has failed due to an error, can be relaunched after resetting it.
}
\details{
A lazy, vanilla \link{Future} can be reused in another R session. For
instance, if we do:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(future)
a <- 2
f <- future(42 * a, lazy = TRUE)
saveRDS(f, "myfuture.rds")
}\if{html}{\out{</div>}}

Then we can read and evaluate the future in another R session using:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(future)
f <- readRDS("myfuture.rds")
v <- value(f)
print(v)
#> [1] 84
}\if{html}{\out{</div>}}
}
\examples{
## Like mean(), but fails 90\% of the time
shaky_mean <- function(x) {
  if (as.double(Sys.time()) \%\% 1 < 0.90) stop("boom")
  mean(x)
}

x <- rnorm(100)

## Calculate the mean of 'x' with a risk of failing randomly
f <- future({ shaky_mean(x) })

## Relaunch until success
repeat({
  v <- tryCatch(value(f), error = identity)
  if (!inherits(v, "error")) break
  message("Resetting failed future, and retry in 0.1 seconds")
  f <- reset(f)
  Sys.sleep(0.1)
})
cat("mean:", v, "\n")
}
