% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_resource.R
\name{add_resource}
\alias{add_resource}
\title{Add a Data Resource}
\usage{
add_resource(
  package,
  resource_name,
  data,
  schema = NULL,
  replace = FALSE,
  delim = ",",
  ...
)
}
\arguments{
\item{package}{Data Package object, as returned by \code{\link[=read_package]{read_package()}} or
\code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}

\item{data}{Data to attach, either a data frame or path(s) to CSV file(s):
\itemize{
\item Data frame: attached to the resource as \code{data} and written to a CSV file
when using \code{\link[=write_package]{write_package()}}.
\item One or more paths to CSV file(s) as a character (vector): added to the
resource as \code{path}.
The last file will be read with \code{\link[readr:read_delim]{readr::read_delim()}} to create or
compare with \code{schema} and to set \code{format}, \code{mediatype} and \code{encoding}.
The other files are ignored, but are expected to have the same structure
and properties.
}}

\item{schema}{Either a list, or path or URL to a JSON file describing a Table
Schema for the \code{data}.
If not provided, one will be created using \code{\link[=create_schema]{create_schema()}}.}

\item{replace}{If \code{TRUE}, the added resource will replace an existing
resource with the same name.}

\item{delim}{Single character used to separate the fields in the CSV file(s),
e.g. \verb{\\t} for tab delimited file.
Will be set as \code{delimiter} in the resource Table Dialect, so read functions
.  know how to read the file(s).}

\item{...}{Additional \href{https://docs.ropensci.org/frictionless/articles/data-resource.html#properties-implementation}{metadata properties}
to add to the resource, e.g. \verb{title = "My title", validated = FALSE}.
These are not verified against specifications and are ignored by
\code{\link[=read_resource]{read_resource()}}.
The following properties are automatically set and can't be provided with
\code{...}: \code{name}, \code{data}, \code{path}, \code{schema}, \code{profile}, \code{format}, \code{mediatype},
\code{encoding} and \code{dialect}.}
}
\value{
\code{package} with one additional resource.
}
\description{
Adds a Data Resource to a Data Package.
The resource will be a \href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource}.
The resource name can only contain lowercase alphanumeric characters plus
\code{.}, \code{-} and \verb{_}.
}
\details{
See \code{vignette("data-resource")} (and to a lesser extend
\code{vignette("table-dialect")}) to learn how this function implements the
Data Package standard.
}
\examples{
# Load the example Data Package
package <- example_package()

# List the resources
resources(package)

# Create a data frame
df <- data.frame(
  multimedia_id = c(
    "aed5fa71-3ed4-4284-a6ba-3550d1a4de8d",
    "da81a501-8236-4cbd-aa95-4bc4b10a05df"
  ),
  x = c(718, 748),
  y = c(860, 900)
)

# Add the resource "positions" from the data frame
package <- add_resource(package, "positions", data = df)

# Add the resource "positions_with_schema", with a user-defined schema and title
my_schema <- create_schema(df)
package <- add_resource(
  package,
  resource_name = "positions_with_schema",
  data = df,
  schema = my_schema,
  title = "Positions with schema"
)

# Replace the resource "observations" with a file-based resource (2 TSV files)
path_1 <-
system.file("extdata", "v1", "observations_1.tsv", package = "frictionless")
path_2 <-
system.file("extdata", "v1", "observations_2.tsv", package = "frictionless")
package <- add_resource(
  package,
  resource_name = "observations",
  data = c(path_1, path_2),
  replace = TRUE,
  delim = "\t"
)

# List the resources ("positions" and "positions_with_schema" added)
resources(package)
}
\seealso{
Other edit functions: 
\code{\link{remove_resource}()}
}
\concept{edit functions}
