% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{deriv}
\alias{deriv}
\title{Compute derivatives of HRF functions}
\usage{
deriv(x, t, ...)
}
\arguments{
\item{x}{An HRF object}

\item{t}{Numeric vector of time points at which to evaluate the derivative}

\item{...}{Additional arguments passed to specific methods}
}
\value{
Numeric vector or matrix of derivative values at the specified time
  points. For multi-basis HRFs, returns a matrix with one column per basis
  function.
}
\description{
Calculates the derivative of a Hemodynamic Response Function (HRF) at
specified time points. This is useful for:
\itemize{
  \item{Understanding HRF dynamics and rate of change}
  \item{Creating temporal derivative regressors for fMRI models}
  \item{Analyzing HRF shape characteristics}
  \item{Implementing advanced HRF basis sets}
}
}
\details{
The derivative computation method depends on the HRF type:
\itemize{
  \item{Analytic derivatives are used when available (e.g., SPMG1, SPMG2,
    SPMG3)}
  \item{Numeric finite-difference approximation is used as fallback}
}

The default implementation uses \code{numDeriv::grad} for numerical
differentiation when analytic derivatives are not available.
}
\examples{
# Compute derivative of SPM canonical HRF
t <- seq(0, 20, by = 0.1)
hrf_deriv <- deriv(HRF_SPMG1, t)

# Plot HRF and its derivative
hrf_vals <- evaluate(HRF_SPMG1, t)
plot(t, hrf_vals, type = "l", col = "black",
     ylab = "Response", xlab = "Time (s)")
lines(t, hrf_deriv, col = "red", lty = 2)
legend("topright", c("HRF", "Derivative"),
       col = c("black", "red"), lty = c(1, 2))

# For multi-basis HRFs, returns matrix
deriv_matrix <- deriv(HRF_SPMG3, t)
# Returns derivatives for all 3 basis functions

}
\seealso{
[evaluate()], [HRF_objects], [numDeriv::grad()]

Other hrf: 
\code{\link{HRF_objects}},
\code{\link{penalty_matrix}()}
}
\concept{hrf}
