% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop-GHSLdata.R
\name{crop_GHSLdata}
\alias{crop_GHSLdata}
\title{Crop GHSL data to the provided extent}
\usage{
crop_GHSLdata(
  extent,
  output_directory,
  global_directory,
  output_filenames,
  global_filenames,
  buffer = 5
)
}
\arguments{
\item{extent}{SpatRaster, or any other object that has a SpatExtent}

\item{output_directory}{character. Path to the directory to save the cropped grids}

\item{global_directory}{character. Path to the directory where the global grids are saved (created with \code{\link[=download_GHSLdata]{download_GHSLdata()}})}

\item{output_filenames}{vector of length 3 with the filenames used to save the built-up area, population and land grid in \code{output_directory}}

\item{global_filenames}{vector of length 3 with the filenames of the built-up area, population and land grid in \code{global_directory}}

\item{buffer}{integer. If larger than 0, a buffer of \code{buffer} cells will be added around the borders of the extent to allow cities or towns at the edges to be correctly classified.}
}
\value{
path to the created files.
}
\description{
The grid cell classification of the Degree of Urbanisation requires three different inputs: a built-up area grid, a population grid, and a land grid. The grids can be downloaded from the GHSL website with \code{\link[=download_GHSLdata]{download_GHSLdata()}}.

This function reads the downloaded grids from the \code{global_directory} and crops them to the provided extent. The newly cropped grids will be saved in the \code{output_directory}, together with their respective metadata (in JSON format).
}
