% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-urban-centres.R
\name{DoU_classify_grid_urban_centres}
\alias{DoU_classify_grid_urban_centres}
\title{Create the DEGURBA grid cell classification of urban centres}
\usage{
DoU_classify_grid_urban_centres(
  data,
  density_threshold = 1500,
  size_threshold = 50000,
  contiguity_rule = 4,
  built_criterium = TRUE,
  built_threshold = 0.2,
  smooth_pop = FALSE,
  smooth_pop_window = 5,
  gap_fill = TRUE,
  max_gap = 15,
  smooth_edge = TRUE,
  smooth_edge_fun = "majority_rule_R2023A",
  value = 3
)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{density_threshold}{numeric. Minimum population density per permanent land of a cell required to belong to an urban centre}

\item{size_threshold}{numeric. Minimum total population size required for an urban centre}

\item{contiguity_rule}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}

\item{built_criterium}{logical. Whether to use the additional built-up area criterium (see details). If \code{TRUE}, not only cells that meet the population density requirement will be considered when delineating urban centres, but also cells with a built-up area per permanent land above the \code{built_threshold}}

\item{built_threshold}{numeric. Additional built-up area threshold. A value between \code{0} and \code{1}, representing the minimum built-up area per permanent land. Ignored when \code{built_criterium} is \code{FALSE}.}

\item{smooth_pop}{logical. Whether to smooth the population grid before delineating urban centres. If \code{TRUE}, the population grid will be smoothed with a moving average of window size \code{smooth_pop_window}.}

\item{smooth_pop_window}{integer. Size of the moving window used to smooth the population grid before delineating urban centres. Ignored when \code{smooth_pop} is \code{FALSE}.}

\item{gap_fill}{logical. Whether to perform gap filling. If \code{TRUE}, gaps in urban centres smaller than \code{max_gap} are filled.}

\item{max_gap}{integer. Gaps with an area smaller than this threshold in urban centres will be filled (unit is km²). Ignored when \code{gap_fill} is \code{FALSE}.}

\item{smooth_edge}{logical. Whether to perform edge smoothing. If \code{TRUE}, edges of urban centres are smoothed with the function \code{smooth_edge_fun}.}

\item{smooth_edge_fun}{character / function. Function used to smooth the edges of urban centres. Ignored when \code{smooth_edge} is \code{FALSE}. Possible values are:
\itemize{
\item \code{"majority_rule_R2022A"} to use the edge smoothing algorithm in GHSL Data Package 2022 (see details)
\item \code{"majority_rule_R2023A"} to use the edge smoothing algorithm in GHSL Data Package 2023 (see details)
\item a custom function with a signature similar as \code{\link[=apply_majority_rule]{apply_majority_rule()}}.
}}

\item{value}{integer. Value assigned to urban centres in the resulting grid}
}
\value{
SpatRaster with the grid cell classification of urban centres
}
\description{
The Degree of Urbanisation identifies urban centres as clusters of continuous grid cells (based on rook contiguity) with a minimum density of 1500 inhabitants per km² (or with a minimum built-up area; see details), and a minimum total population of 50 000 inhabitants. Gaps smaller than 15 km² in the urban centres are filled and edges are smoothed by a 3x3-majority rule (see details).

For more information about the Degree of Urbanisation methodology, see the \href{https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Applying_the_degree_of_urbanisation_manual}{methodological manual}, \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022} and \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}.

The arguments of the function allow to adapt the standard specifications in the Degree of Urbanisation in order to construct an alternative version of the grid classification.
}
\details{
\itemize{
\item \strong{Optional built-up area criterium}
}

In Data Package 2022, the Degree of Urbanisation includes an optional built-up area criterium to account for the presence of office parks, shopping malls, factories and transport infrastructure. When the setting is enabled, urban centres are created using both cells with a population density of at least 1500 inhabitants per km² \emph{and} cells that have at least 50\% built-up area on permanent land. For more information: see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022, footnote 25}. The parameter setting \code{built_criterium=TRUE} and \code{built_threshold=0.5} reproduces this built-up area criterium.

In Data Package 2023, the built-up area criterium is slightly adapted and renamed to the "Reduce Fragmentation Option". Instead of using a fixed threshold of built-up area per permanent land of 50\%, an "optimal" threshold is employed. The optimal threshold is dynamically identified as the global average built-up area proportion in clusters with a density of at least 1500 inhabitants per permanent land with a minimum population of 5000 people. For more information: see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023, footnote 30}. The optimal built-up threshold can be computed with the function \code{\link[=DoU_get_optimal_builtup]{DoU_get_optimal_builtup()}}. We determined empirically that this optimal threshold is 20\% for the data of 2020.
\itemize{
\item \strong{Edge smoothing: majority rule algorithm}
}

In Data Package 2022, edges of urban centres are smoothed by an iterative majority rule. The majority rule works as follows: if a cell has at least five of the eight surrounding cells belonging to an unique urban centre, then the cell is added to that urban centre. The process is iteratively repeated until no more cells are added. The parameter setting \code{smooth_edge=TRUE} and \code{smooth_edge_fun="majority_rule_R2022A"} reproduces this edge smoothing rule.

In Data Package 2023, the majority rule is slightly adapted. A cell is added to an urban centre if the majority of the surrounding cells belongs to an unique urban centre, with majority only computed among populated or land cells (proportion of permanent land > 0.5). In addition, cells with permanent water are never added to urban centres. The process is iteratively repeated until no more cells are added. For more information: see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023, footnote 29}. The parameter setting \code{smooth_edge=TRUE} and \code{smooth_edge_fun="majority_rule_R2023A"} reproduces this edge smoothing rule.
}
\examples{
data_belgium <- DoU_load_grid_data_belgium()

# standard parameters of the Degree of Urbanisation:
classification1 <- DoU_classify_grid_urban_centres(data_belgium)
DoU_plot_grid(classification1)

# with custom parameters:
classification2 <- DoU_classify_grid_urban_centres(data_belgium,
  density_threshold = 1000,
  gap_fill = FALSE,
  smooth_edge = FALSE
)
DoU_plot_grid(classification2)

}
