% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_regression.R
\name{predictions.fuzzy_lm}
\alias{predictions.fuzzy_lm}
\title{Accessor for Predictions}
\usage{
\method{predictions}{fuzzy_lm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fuzzy_lm}. The model object.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A list of fuzzy predictions.
}
\description{
Accessor for Predictions
}
\examples{
# Simulate data and fit a fuzzy linear model
set.seed(123)
X_crisp <- matrix(round(runif(300, 2, 10)), nrow = 100, ncol = 3)
beta <- c(1.5, -0.8, 2.0)
Y_crisp <- round(X_crisp \%*\% beta + rnorm(100, mean = 0, sd = 1))
X_fuzzy <- fuzzify_crisp_matrix(X_crisp, spread = 1)
Y_fuzzy <- fuzzify_crisp_vector(Y_crisp, spread = 1)
object <- fuzzy_lm(X_fuzzy, Y_fuzzy, p = 3)

# Extract predictions
head(predictions(object))
}
