% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborhoodMatrix.r
\name{neighborhoodMatrix,GVector-method}
\alias{neighborhoodMatrix,GVector-method}
\alias{neighborhoodMatrix}
\alias{neighbourhoodMatrix,GVector-method}
\alias{neighbourhoodMatrix}
\title{Neighborhood matrix from a polygons GVector}
\usage{
\S4method{neighborhoodMatrix}{GVector}(x)

\S4method{neighbourhoodMatrix}{GVector}(x)
}
\arguments{
\item{x}{A polygons `GVector.}
}
\value{
A \code{list}. Each element represents a polygon. If an element is empty, it has no neighbors. Otherwise, it is a vector of integers, which represent the indices of the polygon(s) to which it is a neighbor.
}
\description{
This function returns a neighborhood matrix from a polygons \code{GVector}, which represents which geometries touch one another. It is useful for implementing geostatistical analyses that require indicators about which area features are next to one another.

Polygons must share more than one point for them to be considered a neighbors (i.e., same as \code{spdep::poly2nb(x, queen = FALSE)}).

This function needs the \strong{GRASS} addon \code{v.neighborhoodmatrix}. If it is not installed, it will try to install it.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Polygons vector:
madCoast4 <- fastData(madCoast4)
mc4 <- fast(madCoast4)

neighs <- neighborhoodMatrix(mc4)
neighs

}
}
