% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.r
\name{freq,GRaster-method}
\alias{freq,GRaster-method}
\alias{freq}
\title{Frequencies of cell values in a raster}
\usage{
\S4method{freq}{GRaster}(x, digits = 3, bins = 100, value = NULL)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{digits}{Numeric integer: Number of digits by which to round raster values. Ignored for integer and categorical rasters.}

\item{bins}{Positive numeric integer: Number of bins in which to divide values of \code{numeric} rasters. The default is 100. For \code{integer} and categorical rasters, each value is tallied (i.e., this is ignored).}

\item{value}{Numeric or \code{NULL} (default): If numeric, only cells with this value will be counted. If \code{NULL}, all values will be counted.}
}
\value{
A \code{data.frame} or a named \code{list} of \code{data.frame}s, one per layer in \code{x}.
}
\description{
\code{freq()} tabulates the frequency of cell values in a raster. For rasters where \code{\link[=datatype]{datatype()}} is \code{integer} or \code{factor}, the frequency of each value or level is reported. For other rasters, the range of values is divided into bins, and the number of cells with values in each bin is reported.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev") # raster
madCover <- fastData("madCover") # categorical raster

# Convert to GRasters
elev <- fast(madElev) # raster
cover <- fast(madCover) # categorical raster

# Frequencies of integer raster values
f <- freq(elev)
print(f) # have to do this sometimes if output is a data table

# Frequencies of categorical raster values
f <- freq(cover)
print(f) # have to do this sometimes if output is a data table

# Frequencies of given values
f <- freq(elev, value = 1)
print(f) # have to do this sometimes if output is a data table

# When a GRaster has non-integer values, they will be binned:
f <- freq(elev + 0.1, bins = 10)
print(f)

}
}
\seealso{
\code{\link[terra:freq]{terra::freq()}}, tool \code{r.stats} in \strong{GRASS}
}
