% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentation.r
\name{fragmentation,SpatRaster-method}
\alias{fragmentation,SpatRaster-method}
\alias{fragmentation}
\alias{fragmentation,GRaster-method}
\title{Landscape fragmentation class following Riitters et al. (2020)}
\usage{
\S4method{fragmentation}{SpatRaster}(
  x,
  w = 3,
  undet = "undetermined",
  none = NA,
  na.rm = TRUE,
  cores = faster("cores"),
  verbose = TRUE
)

\S4method{fragmentation}{GRaster}(x, w = 3, undet = "undetermined", none = NA, verbose = TRUE)
}
\arguments{
\item{x}{A \code{SpatRaster} or \code{GRaster}.}

\item{w}{An odd, positive integer: Size of the window across which fragmentation is calculated (in units of "rows" and "columns"). The default is 3, meaning the function uses a 3x3 moving window to calculate fragmentation. For large rasters, compute time is ~\emph{O}(\code{N}) + \emph{O}(\code{N * w^2}), where \code{N} is the number of cells in the raster. So, even a small increase in \code{w} can increase compute time by a lot.}

\item{undet}{Character: How to assign the "undetermined" case. Valid values are \code{"perforated"} (default), \code{"edge"}, and \code{"undetermined"}. Partial matching is used. If \code{Pf} is the proportional density raster cell value and \code{Pff} the proportional connectivity raster cell value, the undetermined case occurs when \code{Pf} > 0.6 and \code{Pf == Pff}.}

\item{none}{Integer or \code{NA} (default): Value to assign to a cell with no focal habitat. Riitters et al. use \code{NA}. This will be forced to an integer if it is not an actual integer.}

\item{na.rm}{Logical: If \code{TRUE} (default) and \code{x} is a \code{SpatRaster}, then cells near the edge of the raster where the window overlaps the edge can still be assigned a fragmentation class. If \code{FALSE}, these cells will be assigned a value of \code{none}.}

\item{cores}{Integer: Number of processor cores to use for when processing a \code{SpatRaster}.}

\item{verbose}{Logical: If \code{TRUE} (default), display progress.}
}
\value{
A categorical \code{SpatRaster} or \code{GRaster}. The values assigned to each class can be seen with \code{\link[=levels]{levels()}}.
}
\description{
Riitters et al. (2020) propose a classification scheme for forest fragmentation (which can be applied to any habitat type). The scheme relies on calculating density (e.g., number of forested cells in a window around a focal cell) and connectivity (number of cases where neighboring cells are both forested). This function calculates these classes from a \code{GRaster} or \code{SpatRaster} in which the focal habitat type has cell values of 1, and non-focal habitat type has cell values of 0 or \code{NA}.

Note that by default, the \code{SpatRaster} and \code{GRaster} versions will create different results around the border of the raster. The \code{SpatRaster} version uses the \code{\link[terra:focal]{terra::focal()}} function, which will not return an \code{NA} value when its window overlaps the raster border if the \code{na.rm} argument is \code{TRUE}. However, the \code{GRaster} version uses the \strong{GRASS} tool \code{r.neighbors}, which does return \code{NA} values in these cases.

The fragmentation classes are:
\itemize{
\item Value provided by \code{none}: None (i.e., no forest; default is \code{NA}).
\item 1: Patch
\item 2: Transitional
\item 3: Perforated
\item 4: Edge
\item 5: Undetermined (not possible to obtain when \code{w = 3})
\item 6: Interior
}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data:
madForest <- fastData("madForest2000") # raster

### Fragmentation classes from a SpatRaster

fragTerra <- fragmentation(madForest)
plot(fragTerra)
levels(fragTerra)
freq(fragTerra)

### Fragmentation classes from a GRaster

# Convert to GRaster:
forest <- fast(madForest)

# Fragmentation class:
frag <- fragmentation(forest)
plot(frag)
levels(frag)
freq(frag)

}
}
\references{
Riitters, K., J. Wickham, R. O'Neill, B. Jones, and E. Smith. 2000. Global-scale patterns of forest fragmentation. \emph{Conservation Ecology} 4:3. URL: \url{http://www.consecol.org/vol4/iss2/art3/}. Also note the \href{https://www.ecologyandsociety.org/vol4/iss2/art3/errata/january26.2001.html}{errata}.
}
