% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclim_terra.R
\name{bioclim_terra}
\alias{bioclim_terra}
\title{In-Memory Bioclimatic Variable Calculation}
\usage{
bioclim_terra(
  bios,
  tmin = NULL,
  tmax = NULL,
  tavg = NULL,
  prcp = NULL,
  srad = NULL,
  mois = NULL,
  period_length = 3,
  circular = TRUE,
  gdal_opt = c("COMPRESS=DEFLATE", "PREDICTOR=3", "NUM_THREADS=ALL_CPUS"),
  overwrite = FALSE,
  output_dir = tempdir(),
  ...
)
}
\arguments{
\item{bios}{Numeric vector of variables to compute.}

\item{period_length}{Integer, length of a calculation period.}

\item{circular}{Logical, whether to wrap periods.}

\item{gdal_opt}{Character vector of GDAL options for writing.}

\item{overwrite}{Logical, whether to overwrite existing files.}

\item{output_dir}{Character, path to save final rasters.}

\item{...}{`SpatRaster` objects for climate variables (e.g., `tmin`, `tmax`)
and static indices (e.g., `warmest_period`).}
}
\value{
A `terra::SpatRaster` object pointing to the newly created files.
}
\description{
Internal function to calculate bioclimatic variables using `terra` functions.
It is designed for datasets that can fit into RAM.
}
\seealso{
The user-facing wrapper function `derive_bioclim()`.
}
\keyword{internal}
