% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fad.r
\name{fad}
\alias{fad}
\title{Factor Analysis for data (high or low dimensional).}
\usage{
fad(
  x,
  factors,
  data = NULL,
  covmat = NULL,
  n.obs = NA,
  subset,
  na.action,
  start = NULL,
  scores = c("none", "regression", "Bartlett"),
  rotation = "varimax",
  control = NULL,
  lower = 0.005,
  ...
)
}
\arguments{
\item{x}{A formula or a numeric matrix or an object that can be coerced to a
numeric matrix.}

\item{factors}{The number of factors to be fitted.}

\item{data}{An optional data frame (or similar: see \code{\link[stats]{model.frame}}),
used only if \code{x} is a formula.  By default the variables are taken
from \code{environment(formula)}.}

\item{covmat}{A covariance matrix, or a covariance list as returned by
\code{\link[stats]{cov.wt}}. Of course, correlation matrices are covariance
matrices.}

\item{n.obs}{The number of observations, used if \code{covmat} is a
covariance matrix.}

\item{subset}{A specification of the cases to be used, if \code{x} is used as
a matrix or formula.}

\item{na.action}{The \code{na.action} to be used if \code{x} is used as a
formula.}

\item{start}{\code{NULL} or a matrix of starting values, each column giving
an initial set of uniquenesses.}

\item{scores}{Type of scores to produce, if any.  The default is none,
\code{"regression"} gives Thompson's scores, \code{"Bartlett"} given
Bartlett's weighted least-squares scores. Partial matching allows these
names to be abbreviated. Also note that some of the scores-types are not
applicable when \code{p > n}.}

\item{rotation}{character. \code{"none"} or the name of a function to be used
to rotate the factors: it will be called with first argument the loadings
matrix, and should return a list with component \code{loadings} giving the
rotated loadings, or just the rotated loadings. The options included in the package are:
\code{varimax}, \code{promax}, \code{quartimax}, \code{equamax}.}

\item{control}{A list of control values:
\describe{
\item{nstart}{The number of starting values to be tried if \code{start = NULL}. Default 1.}
\item{trace}{logical. Output tracing information? Default \code{FALSE}.}
\item{opt}{A list of control values to be passed to \code{\link[stats]{optim}}'s
\code{control} argument.}
\item{rotate}{a list of additional arguments for the rotation function.}
}}

\item{lower}{The lower bound for uniquenesses during optimization. Should be > 0. Default 0.005.}

\item{\dots}{Components of \code{control} can also be supplied as named arguments to \code{fad}.}
}
\value{
An object of class \code{"fad"} with components
\item{loadings}{A matrix of loadings on the correlation scale, one column for each factor.  The
factors are ordered in decreasing order of sums of squares of
loadings, and given the sign that will make the sum of the loadings
positive.  This is of class \code{"loadings"}}
\item{uniquenesses}{The uniquenesses computed on the correlation scale.}
\item{sd}{The estimated standard deviations.}
\item{criteria}{The results of the optimization: the value of the
criterion (a linear function of the negative log-likelihood) and information
on the iterations used.}
\item{factors}{The argument \code{factors}.}
\item{dof}{The number of degrees of freedom of the factor analysis model.}
\item{method}{The method: always \code{"mle"}.}
\item{rotmat}{The rotation matrix if relevant.}
\item{scores}{If requested, a matrix of scores.  \code{napredict} is
applied to handle the treatment of values omitted by the \code{na.action}.}
\item{n.obs}{The number of observations if available, or \code{NA}.}
\item{call}{The matched call.}
\item{na.action}{If relevant.}
\item{loglik, BIC}{The maximum log-likelihood and the Bayesian Information Criteria.}
}
\description{
Perform fast matrix-free maximum-likelihood factor analysis on a
  covariance matrix or data matrix, works if number of variables is more than
  number of observations.
}
\examples{
set.seed(1234)

## Simulate a 200 x 3 loadings matrix ~i.i.d N(0,1)
L <- matrix(rnorm(200*3),200,3) 

## Simulate the uniquenesses i.i.d U(0.2,0.9)
D <- runif(200,0.2,0.9) 

## Generate a data matrix of size 50 x 200 with rows
## ~i.i.d. N(0,LL'+diag(D))
X <- tcrossprod(matrix(rnorm(50*3),50,3),L) + matrix(rnorm(50*200),50,200) \%*\% diag(sqrt(D))

## Fit a factor model with 3 factors:
fit = fad(X,3)


## Print the loadings:
print(fit$loadings)

}
\seealso{
\code{\link[stats]{factanal}}
}
