test_that("graphics work", {
  testthat::skip_if_offline("livetiming.formula1.com")
  skip_if_no_py()
  skip_if_no_ff1()

  # Set testing specific parameters - this disposes after the test finishes
  # Note: The test suite can't delete the old fastf1_http_cache.sqlite file
  # because python's process has it locked.
  if (dir.exists(file.path(tempdir(), "tst_graphics"))) {
    unlink(file.path(tempdir(), "tst_graphics"), recursive = TRUE, force = TRUE)
  }
  withr::local_file(file.path(tempdir(), "tst_graphics"))
  dir.create(file.path(tempdir(), "tst_graphics"), recursive = TRUE)
  withr::local_options(f1dataR.cache = file.path(tempdir(), "tst_graphics"))
  withr::local_seed(1234)

  # Ensure caught failure if no ggplot2, then skip remainder
  if (!require("ggplot2", quietly = TRUE)) {
    expect_error(
      plot_fastest(season = 2023, round = 1, session = "R", driver = "HAM", color = "gear"),
      "f1dataR::plot_fastest() requires ggplot2 package installation"
    )
    testthat::skip("ggplot2 not available for testing graphics")
  }

  # Ensure caught failure if old ff1, then skip remainder
  ff1_ver <- get_fastf1_version()
  if (ff1_ver < "3.1") {
    expect_error(
      session <- load_race_session(season = 2023, round = 1),
      "An old version of FastF1 is in use"
    )
    skip("Skipping graphics tests as FastF1 is out of date.")
  }

  # Check deprecation
  expect_error(
    plot_fastest(season = 2023, race = 1, session = "R", driver = "HAM", color = "gear"),
    "was deprecated in f1dataR"
  )

  # Snapshot Tests of graphics
  suppressMessages({
    suppressWarnings({
      gear <- plot_fastest(2023, 1, "R", "HAM", "gear")
      speed <- plot_fastest(2023, 1, "R", "HAM", "speed")
      qualiplot <- plot_fastest(2023, 1, "Q", "HAM", "gear")
    })
  })
  expect_equal(gear$label$title, speed$label$title)
  expect_equal(gear$label$caption, "Generated by {f1dataR} package")
  expect_true(grepl("Lewis Hamilton Fastest Lap", gear$label$subtitle))

  expect_equal(qualiplot$label$title, "2023 Bahrain Grand Prix Qualifying")

  qp_axis <- qualiplot + theme_dark_f1(axis_marks = TRUE)

  expect_equal(qp_axis$labels, qualiplot$labels)
})

test_that("correct_track_ratio works", {
  # Ensure caught failure if no ggplot2, then skip remainder
  if (!require("ggplot2", quietly = TRUE)) {
    expect_error(
      correct_track_ratio("bob"),
      "requires ggplot2 package installation"
    )
    testthat::skip("ggplot2 not available for testing graphics")
  }
  expect_error(correct_track_ratio("bob"), "`trackplot` must be a `ggplot` object")
})

test_that("graphics works without internet", {
  skip_if_no_py()
  skip_if_no_ff1()

  # Set testing specific parameters - this disposes after the test finishes
  # Note: The test suite can't delete the old fastf1_http_cache.sqlite file
  # because python's process has it locked.
  if (dir.exists(file.path(tempdir(), "tst_graphics2"))) {
    unlink(file.path(tempdir(), "tst_graphics2"), recursive = TRUE, force = TRUE)
  }
  withr::local_file(file.path(tempdir(), "tst_graphics2"))
  dir.create(file.path(tempdir(), "tst_graphics2"), recursive = TRUE)
  withr::local_options(f1dataR.cache = file.path(tempdir(), "tst_graphics2"))

  ff1_ver <- get_fastf1_version()
  if (ff1_ver < "3.1") {
    skip("Skipping load_circuit_details (no internet) test as FastF1 is out of date.")
  }
  # if no ggplot2, then skip remainder
  if (!require("ggplot2", quietly = TRUE)) {
    testthat::skip("ggplot2 not available for testing graphics")
  }

  clear_cache()

  if (requireNamespace("httptest2", quietly = TRUE)) {
    # This will normally print many warnings and errors to the test log, we don't need those (we expect them as
    # a byproduct of the without_internet call
    suppressWarnings({
      suppressMessages({
        httptest2::without_internet({
          expect_message(plot_fastest(2023, 1, "R", "HAM", "gear"), "f1dataR: Can't connect to F1 Live Timing for FastF1 data download")
          expect_null(plot_fastest(2023, 1, "R", "HAM", "gear"))
        })
      })
    })
  }
})
