% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_recognition_data.R
\docType{data}
\name{word_recognition}
\alias{word_recognition}
\title{Data collected in an infant eyetracking study}
\format{
A data frame with 53940 rows and 10 variables: \describe{ \item{ParticipantName}{Uniaue 
  participant ID} \item{Sex}{M or F} \item{Age}{Age, in months} \item{TrialNum}{Unique Trial 
  Number} \item{Trial}{Name of item shown on trial (also unique for each participant)} 
  \item{TimeFromTrialOnset}{Time within trial} \item{Subphase}{Subphase within trial (see above)}
  \item{TimeFromSubphaseOnset}{Time within subphase} \item{AOI}{Which AOI are they looking at} 
  \item{Animate}{Are they looking at the animate AOI?} \item{Inanimate}{Are they looking at the 
  inanimate AOI?} \item{TrackLoss}{Does current sample not have valid tracking data?} 
  \item{MCDI_Total}{Total vocabulary score on MCDI} \item{MCDI_Nouns}{Noun vocabulary score on 
  MCDI} \item{MCDI_Verbs}{Verb vocabulary score on MCDI} ... }
}
\source{
Ferguson, B., Graf, E., & Waxman, S. R. (2014). Infants use known verbs to learn novel
  nouns: Evidence from 15- and 19-month-olds. Cognition, 131(1), 139-146.
}
\usage{
word_recognition
}
\description{
Data from a simple 2-alternative forced choice (2AFC) word recognition task administered to 19- 
and 24-month-olds. On each trial, infants were shown a picture of an animate object (e.g., a 
horse) and an inanimate object (e.g., a spoon). After inspecting the images, they disappeared and
they heard a label referring to one of them (e.g., "The horse is nearby!"). Finally, the objects 
re-appeared on the screen and they were prompted to look at the target (e.g., "Look at the 
horse!").
}
\keyword{datasets}
