\name{frailty.fit}
\alias{frailty.fit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fitted different shared frailty models
}
\description{
frailty.fit computes the maximum likelihood estimates based on the EM algorithm for the
shared gamma, inverse gaussian, weighted Lindley, Birnbaum-Saunders, truncated normal,
mixture of inverse gaussian and mixture of Birbaum-Saunders frailty models. 
}
\usage{
frailty.fit(formula, data, dist.frail="gamma", dist = "np", prec = 1e-04, 
        max.iter = 1000, part=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{
A formula that contains on the left hand side an object of the type Surv and on the right hand side a 
+cluster(id) statement, possibly with the covariates definition.
}
  \item{data}{
A data.frame in which the formula argument can be evaluated
}
  \item{dist.frail}{
the distribution assumed for the frailty. Supported values: gamma (GA also is valid), IG (inverse gaussian), WL
(weighted Lindley), BS (Birnbaum-Saunders), TN (truncated normal), MIG (mixture of IG), MBS (mixture of BS),
GE (generalized exponential) and JSW (Jorgensen-Seshadri-Whitmore).
}
  \item{dist}{
the distribution assumed for the basal model. Supported values: weibull, pe (piecewise exponential),
exponential and np (non-parametric).
}
  \item{prec}{
The convergence tolerance for parameters.  
}
  \item{max.iter}{
The maximum number of iterations.
}
  \item{part}{
partition time (only for piecewise exponential distribution).
}
}
\details{
The multiplicative frailty models are defined in the following way.
Consider the time to the event of an individual to be denoted by a random variable \eqn{T}, where the latent effect 
\eqn{Z} acts multiplicative in the baseline hazard function, whose hazard function, conditional on a latent variable \eqn{Z}, 
satisfies 
\deqn{
\lambda(t|Z)=Z \,\lambda_0(t), t >0,} 
where \eqn{\lambda_0(t)} is a baseline hazard function and \eqn{Z} is the frailty of the individual, and \eqn{\Lambda_0(t) = \int_{0}^{t}\lambda_0(w)\textrm{d}w}
is the cumulative baseline hazard function.

Let \eqn{Z_i > 0}, \eqn{i=1,\ldots,n}, be the latent random variable representing the frailty term associated with the \eqn{i}-th cluster,
which has \eqn{n_i} observations (note that the \eqn{n_i}'s can be different, i.e., the cluster can be unbalanced).
The case \eqn{n_i=1}, \eqn{\forall i=1,\ldots,n}, is known in the literature as the univariate case.
In a multiplicative hazards framework, given \eqn{Z_i = z_i} and a vector of \eqn{p} covariates (without intercept term), say 
\eqn{\mathbf{x}_i=(x_{i1},\ldots,x_{ip})}, the conditional hazard function for the observations in the \eqn{i}-th cluster is given by
\deqn{
\lambda(t_{i1},\ldots,t_{in_i}\mid z_i, \mathbf{X}_i)=z_i \sum_{j=1}^{n_i} \lambda_0(t) \exp(\mathbf{x}_{ij}^\top {\bm \beta}), \quad i=1,\ldots,n, 
}
where \eqn{{\bm \beta}^\top=(\beta_1,\ldots,\beta_p)} are the regression parameters, respectively, and the distribution of \eqn{Z} 
corresponds to a nonnegative random variable. In this package, it is considered \eqn{Z} such as \eqn{\mathbb{E}(Z)=1} and Var\eqn{(Z)=\theta}.
The options avaliable for the distribution of \eqn{Z} and the corresponding probability density function are:

- gamma: 
\deqn{f(z;\theta)=\frac{1}{\theta^{1\theta}\Gamma(1/\theta)}z^{1/\theta-1}e^{-z/\theta}.}

- IG: 
\deqn{f(z;\theta)=\sqrt{\frac{1}{2\pi\theta z^3}}\exp\left[-\frac{(z-1)^2}{2\theta z}\right].}

- WL (Mota et al; 2021 for the univariate case; Tyagi et al., 2021 for the bivariate case, Gallardo et al. 2025 for the general case):
\deqn{f(z;\theta)=\frac{\theta}{2\Gamma(b_\theta)}a_\theta^{-b_\theta-1}z^{b_\theta-1}(1+z)\exp\left(-\frac{z}{a_\theta}\right),}
where \eqn{a_\theta=\theta(\theta+4)/[2(\theta+2)]} and \eqn{b_\theta=4/[\theta(\theta+4)]}.

- BS (Leao et al; 2021 for the univariate case; Gallardo et al., 2024 for the general case):
\deqn{f(z;\theta)=\frac{\exp(\phi_\theta/2)\sqrt{\phi_\theta+1}}{4z^{3/2}\sqrt{\pi}}\left(z+\frac{\phi_\theta}{\phi_\theta+1}\right)\exp\left[-\frac{\phi_\theta}{4}\left(\frac{z(\phi_\theta+1)}{\phi_\theta}+\frac{\phi_\theta}{z(\phi_\theta+1)}\right)\right],}
where \eqn{\phi_\theta=(1+\sqrt{3\theta+1}-\theta)/\theta}.

The marginal survival function for the times in a same cluster can be expressed in terms of the Laplace transform as
\deqn{S(t_{i1},\ldots,t_{in_i}\mid {\bm X}_i)=\mathcal{L}_Z\left(\sum_{j=1}^{n_i}\exp(\mathbf{x}_i^\top {\bm \beta} \Lambda_0(t_{ij}))\right).}

For the different models considered here, the Laplace transform is given by

- gamma: 
\deqn{\mathcal{L}_Z(s)=(1+\theta s)^{-1/\theta}.}

- IG: 
\deqn{\mathcal{L}_Z(s)=\exp\left[\frac{1}{\theta}\left(1-\sqrt{1+2\theta s}\right)\right].}

- WL:
\deqn{\mathcal{L}_Z(s)=(1+a_\theta s)^{-b_\theta-1}(1+\theta s/2).}

- BS: 
\deqn{\mathcal{L}_Z(s)=\frac{1}{2}\left[1+\left(1+\frac{4s}{\phi_\theta+1}\right)^{-1/2}\right]\exp\left[\frac{\phi_\theta}{2}\left(1-\left(1+\frac{4s}{\phi_\theta+1}\right)^{1/2}\right)\right].}

The estimation is performed based on the EM algorithm. For the weibull, exponential and piecewise exponential distributions 
as the basal model (\eqn{\Lambda_0(\cdot)}), the M1-step is performed using the optim function. For the non-parametric case, 
the M1-step is based on the coxph function from the survival package.
}
\value{
an object of class "extrafrail" is returned. The object returned for this functions is a list containing the following
components:
\item{coefficients}{A named vector of coefficients}
\item{se}{A named vector of the standard errors for the estimated coefficients.}
\item{t}{The vector of times.}
\item{delta}{The failure indicators.}
\item{id}{A variable indicating the cluster which belongs each observation.}
\item{x}{The regressor matrix based on cov.formula (without intercept term).}
\item{dist}{The distribution assumed for the basal model.}
\item{dist.frail}{The distribution assumed for the frailty variable.}
\item{tau}{The Kendall's tau coefficient.}
\item{logLik}{The log-likelihood function (only when the Weibull model is specified for the basal distribution).}
\item{Lambda0}{The observed times and the associated cumulative hazard function (only when the non-parametric
option is specified for the basal distribution)}
\item{part}{the partition time (only for piecewise exponential model).}
}
\references{
Gallardo, D.I., Bourguignon, M., Santibanez, J.L. (2025) The shared weighted Lindley frailty model for
cluster failure time data. Biometrical Journal, 67, e70044.

Gallardo, D.I., Bourguignon, M., Romeo, J. (2024) Birnbaum-Saunders frailty regression 
models for clustered survival data. Statistics and Computing, 34, 141.

Leao, J., Leiva, V., Saulo, H., Tomazella, V. (2017). Birnbaum-Saunders frailty regression models:
Diagnostics and application to medical data. Biometrical journal, 59, 291-317.

Mota, A., Milani, E., Calsavara, V., Tomazella, V., Leao, J., Ramos, P., Ferreira, P., F., L. (2021).
Weighted lindley frailty model: estimation and application to lung cancer data. Lifetime Data
Analysis, 27, 561-587.

Tyagi, S., Pandey, A., Agiwal, V., Chesneau, C. (2021). Weighted Lindley multiplicative regression
frailty models under random censored data. Computational and Applied Mathematics, 40, 265.
}
\author{
Diego Gallardo, Marcelo Bourguignon and John Santibanez.
}
\examples{
\donttest{
require(survival)
#require(frailtyHL)
data(rats, package="frailtyHL")
#Fit for WL frailty model
fit.WL <- frailty.fit(survival::Surv(time, status)~ rx+ survival::cluster(litter), 
dist.frail="WL", data = rats)
summary(fit.WL)
#Fit for gamma frailty model
fit.GA <- frailty.fit(survival::Surv(time, status) ~ rx + survival::cluster(litter), 
dist.frail="gamma", data = rats)
summary(fit.GA)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
