% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_solve.R
\name{prob_solve}
\alias{prob_solve}
\alias{latex_prob}
\alias{probability_solution}
\alias{sprob}
\alias{prob_solve.default}
\alias{lprob}
\alias{toLatex.prob_solve}
\alias{print.prob_solve}
\title{Total or Conditional Probability Computation}
\usage{
prob_solve(target, ...)

\method{prob_solve}{default}(target, ..., partition = NULL, getprob = FALSE, quiet = TRUE)

lprob(txt)

\method{toLatex}{prob_solve}(object, ...)

\method{print}{prob_solve}(x, type = c("numeric", "latex", "prob", "compute"), ...)

latex_prob(txt)

probability_solution(target, ...)

sprob(target, ...)
}
\arguments{
\item{target}{character: target event}

\item{...}{numeric: named events with given probabilities}

\item{partition}{character or list: set of events which form a partition}

\item{getprob}{logical: return all computed probabilities and used computation steps (default: \code{FALSE})}

\item{quiet}{logical: show all computation steps (default: \code{FALSE})}

\item{txt}{character: vector to convert \code{!} to \verb{\\\\bar} and \code{^} to `\\cap'}

\item{object, x}{\code{prob_solve} object}

\item{type}{character: what to print, either \code{numeric} (solution, default), \code{latex} (solution steps in ASCII format),
\code{prob} (optional: all probabilities computed), or \code{compute} (optional: all rules used)}
}
\value{
An object of the class \code{prob_solve} with the resulting probability, including the steps for computing.
If \code{NA} is returned then no solution could be found.
}
\description{
The following functions are available:
\itemize{
\item \code{prob_solve} given a set of events it computes the total or conditional probability of the given event or
\code{NA} if no solution could be found. For the naming of the events upper case letters must be used and
the available operators are \code{!} (complementary event), \code{|} (conditional event), and \code{^} (intersection of events).
The attribute \code{latex} of the return value contains the necessary computation steps for computation of the given event.
If \code{getprob} is \code{TRUE} then additionally the attribute \code{prob}, a vector with all computed probabilities, and \code{compute},
which includes all computational steps, are generated.
\item \code{print} shows the solution way in ASCII.
\item \code{toLatex} shows the solution way in LaTeX/MathJax with an \code{align} environment.
\item \code{lprob} converts \code{!A} to \verb{\\\\bar\{A\}} and \code{A^B} to \verb{A \\\\cap B}.
}
}
\details{
The program applies iteratively the following rules to find a solution:
\itemize{
\item \eqn{P(A) = 1-P(!A)},
\item \eqn{P(A|B) = 1-P(!A|B)},
\item \eqn{P(A^B) = P(B^A)},
\item \eqn{P(B) = P(A^B)+P(!A^B)},
\item \eqn{P(A|B) = P(A^B)/P(B)}, and
\item \eqn{P(A) = P(A|P1)+P(A|P2)+...+ P(A|Pn)} for a partition \eqn{P1, P2, ..., Pn}.
}
}
\examples{
prob_solve("!A", "A"=0.3)
prob_solve("!A|B", "A|B"=0.3)
prob_solve("B^A", "A^B"=0.3)
# P(B)   = P(A^B)+P(!A^B)
prob_solve("B", "A^B"=0.3, "!A^B"= 0.4)
prob_solve("A^B", "B"=0.7, "!A^B"= 0.4)
prob_solve("!A^B", "B"=0.7, "A^B"= 0.3)
# P(A|B) = P(A^B)/P(B)
prob_solve("A|B", "A^B"=0.3, "B"= 0.6)
prob_solve("A^B", "B"=0.6, "A|B"= 0.5)
prob_solve("B", "A|B"=0.5, "A^B"= 0.3)
#' latex, prob and compute attributes
pmt <- prob_solve("M|T", "M"=0.6, "T|M"=0.75, "T|!M"=0.39, quiet=FALSE, getprob=TRUE)
toLatex(pmt)
attr(pmt, "latex")
pmt <- prob_solve("M|T", "M"=0.6, "T|M"=0.75, "T|!M"=0.39, quiet=FALSE, getprob=TRUE)
attr(pmt, "prob")
print(pmt, "latex") 
print(pmt, "prob")    # only if getprob=TRUE   
print(pmt, "compute") # only if getprob=TRUE   
# bayes theorem and total probability
prob_solve("Z", "Z|A"=0.1, "Z|B"=0.2, "Z|C"=0.3, partition=c("A", "B", "C"))
prob_solve("Z|A", "Z"=0.6, "Z|B"=0.2, "Z|C"=0.3, partition=c("A", "B", "C"))
prob_solve('A|K', "A"=0.55, "B"=0.35, "C"=0.1, "K|A"=0.4, "K|B"=0.1, "K|C"=0.1, 
           partition=c("A", "B", "C"))
prob_solve('K', "A"=0.55, "B"=0.35, "C"=0.1, "K|A"=0.4, "K|B"=0.1, "K|C"=0.1, 
           partition=c("A", "B", "C"))
}
