% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{JointSampleSize}
\alias{JointSampleSize}
\alias{JointSampleSize.default}
\alias{JointSampleSize.binary}
\title{Joint Sample Size}
\usage{
JointSampleSize(U, na = NULL, Z = NULL, w = NULL)

\method{JointSampleSize}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{JointSampleSize}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
Returns a matrix of class c("exametrika", "matrix") where each element (i,j)
represents the number of students who responded to both item i and item j. The
diagonal elements represent the total number of responses for each item.
}
\description{
The joint sample size is a matrix whose elements are the number of
individuals who responded to each pair of items.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
