% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{lamVar}
\alias{lamVar}
\title{Variance in lambda}
\usage{
lamVar(Aobj, which.fixed = NULL)
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix.}

\item{which.fixed}{The column-wise indices (single-value index) of the vital
rates to be held at their mean values across all matrices in \code{Aobj}.}
}
\value{
A single value of variance.
}
\description{
In population projection matrices, the eigenvalue with the largest magnitude
is the asymptotic population growth rate, referred to as lambda. This function
calculates the variance in lambda among a group of population projection
matrices, which must all be the same size. This function also has the option
to hold some of the vital rates at their mean values across all the provided
matrices. The resulting calculation is the variance of lambda with all the
non-fixed vital rates are varying. For example, if all the vital rates are
held fixed except for adult fertility, then the output is the variance in
lambda due to variance in adult fertility.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
A_all<- collapse_mat_list(list(A1, A2, A3))
var_all_vary<- lamVar(A_all)
var_fert_vary<- lamVar(A_all, which.fixed=c(2,6,9))
}
