% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{exactLTRE_fixed}
\alias{exactLTRE_fixed}
\title{Exact LTRE analysis: fixed design}
\usage{
exactLTRE_fixed(Aobj, maxint = "all", fixed.directional = FALSE)
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix. For fixed design, exactly
2 matrices must be provided, ordered as \verb{[reference matrix, treatment matrix}].}

\item{maxint}{The maximum interaction order to be evaluated. The default input
is "all" but this input can take any integer value. If maxint=3, then the
output will include contributions terms up to 3-way interactions.}

\item{fixed.directional}{A true/false switch that allows the user to specify
whether a directional LTRE should be used. The default behavior is to calculate
a symmetric LTRE, where the mean matrix is used as the baseline. See details
for more guidance.}
}
\value{
This returns a list object, with 3 items: (1) a vector of the matrix
indices where the parameters vary between/among the matrices in Aobj; (2) a
list of the indices varying for each of the contribution terms provided; (3)
a vector of the contribution terms. For fixed design LTRE these are
contributions to the difference in lambda.

\code{indices.varying} is a vector with the indices of parameters that vary. The
numeric indices count down the columns of a given population projection
matrix. For example, in a 3x3 matrix, the (2,2) position would be identified
with a 5.

\code{varying.indices.list} is a list object, where each entry is a vector
containing the indices (matching the \code{indices.varying} part of the output)
that differed or varied for the corresponding entry in the \code{epsilon} vector.

\code{epsilon} is a vector of contributions to the difference in lambda due to
the observed values of the various life history parameters. For example, the
contribution to the difference in lambda of adult survival is determined by
setting all parameters \emph{except} adult survival to their mean values, and
then calculating the difference in lambda in this manipulated set of
matrices.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations
contributes to difference or variance in the population growth rate, "lambda."
The exact method of LTRE is based on the principles of functional ANOVA.
The equations and descriptions for the exact method will be published in a
forthcoming paper, which we will link to.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix. A fixed design LTRE
decomposes the difference in lambda due to differences at each position of
the matrices. For a fixed design LTRE, exactly 2 matrices must be provided,
ordered as \verb{[reference matrix, treatment matrix}].

\code{fixed.directional=FALSE} is most appropriate for comparisons where it is
not entirely obvious which population should be the reference and which
should be the treatment (for example, when comparing a wet and a dry year). In
this case, the difference in lambda is decomposed using the mean matrix as
the baseline. The decomposition is symmetric, meaning that if the treatment and
reference matrix are swapped, the contributions from the vital rates will be
equal in magnitude, but positive contributions will become negative and vice
versa.

\code{fixed.directional=TRUE} is most appropriate for comparisons between a
control and treatment population in a controlled experiment. In this case,
the reference matrix is treated as the baseline. This is a directional analysis,
meaning that if the reference and treatment matrices were to be swapped, the
contributions of the vital rates would change.

We set \code{fixed.directional=FALSE} as the default behavior because most
population projection models are built with field-collected data rather than
controlled experiment data.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
cont_diff<- exactLTRE_fixed(list(A1,A2), maxint="all") # contributions to the difference in lambda
cont_diff<- exactLTRE_fixed(list(A1,A2), maxint=2) # only first- and second-order terms

# if A1 represents a control and A2 is a treatment:
cont_diff<- exactLTRE_fixed(list(A1,A2), maxint="all", fixed.directional=TRUE)
}
