% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{classicalLTRE}
\alias{classicalLTRE}
\title{Classical LTRE analysis}
\usage{
classicalLTRE(Aobj, method = "random")
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix.

For one-way fixed design, exactly 2 matrices must be provided, ordered as
\verb{[reference matrix, treatment matrix}]. For random design, any set of 2 or
more matrices can be provided. The set of matrices passed in to this
function must all have the same dimensions.}

\item{method}{Either "random" or "fixed." The default behavior is "random."
See details for more information.}
}
\value{
A matrix of contributions to variance (random design) or difference
(one-way fixed design) in lambda. Lambda is the asymptotic population growth
rate, defined as the largest eigenvalue of the population projection matrix.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations
contributes to difference or variance in the population growth rate, "lambda."
The equations and descriptions for the classical methods of LTRE analysis
can be found in Caswell's 2001 textbook. The function we provide here can
perform a one-way fixed design LTRE, or a random design LTRE.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix. A one-way fixed
design LTRE decomposes the difference in lambda due to differences at each
position of the matrices. It should be used when the particular treatment
levels are of interest. For a one-way fixed design LTRE, exactly 2 matrices
must be provided, ordered as \verb{[reference matrix, treatment matrix}]. The
matrix of contributions returned from a classical method fixed design LTRE
will have the same shape as the provided matrices.

A random design LTRE decomposes the variance in lambda due to variance and
covariance in the entries at each position in the matrices. It assumes that
the matrices being analyzed come from a population of similar matrices,
without the particular treatment levels or population conditions being of
interest in themselves. For a random design LTRE, at least 2 matrices must be
provided. The matrix of contributions returned from a classical method
random design LTRE will include both first-order terms (due to variance) and
interaction terms (due to covariance). Therefore, if the provided matrix is
3x3, the matrix of contributions will be 9x9 (the size of the
variance-covariance matrix is the square of the size of the original
matrix). The contributions of variances are found on the diagonal of the
contribution matrix, and the contributions of covariances are symmetric. So
the contribution of covariance between two vital rate parameters is the sum
of the two corresponding off-diagonal terms.

The equations and descriptions for the classical methods of LTRE analysis
can be found in Caswell's 2001 textbook.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
cont_diff<- classicalLTRE(list(A1,A2), method='fixed') # contributions to the difference in lambda
cont_var<- classicalLTRE(list(A1,A2,A3), method='random') # contributions to the variance of lambda
}
