% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MantelModTest.R
\name{MantelModTest}
\alias{MantelModTest}
\alias{MantelModTest.default}
\alias{MantelModTest.list}
\title{Test single modularity hypothesis using Mantel correlation}
\usage{
MantelModTest(cor.hypothesis, cor.matrix, ...)

\method{MantelModTest}{default}(
  cor.hypothesis,
  cor.matrix,
  permutations = 1000,
  MHI = FALSE,
  ...,
  landmark.dim = NULL,
  withinLandmark = FALSE
)

\method{MantelModTest}{list}(
  cor.hypothesis,
  cor.matrix,
  permutations = 1000,
  MHI = FALSE,
  landmark.dim = NULL,
  withinLandmark = FALSE,
  ...,
  parallel = FALSE
)
}
\arguments{
\item{cor.hypothesis}{Hypothetical correlation matrix, with 1s within-modules and 0s between modules.}

\item{cor.matrix}{Observed empirical correlation matrix.}

\item{...}{additional arguments passed to MantelCor}

\item{permutations}{Number of permutations used in significance calculation.}

\item{MHI}{Indicates if Modularity Hypothesis Index should be calculated instead of AVG Ratio.}

\item{landmark.dim}{Used if permutations should be performed maintaining landmark structure in geometric morphometric data. Either 2 for 2d data or 3 for 3d data. Default is NULL for non geometric morphometric data.}

\item{withinLandmark}{Logical. If TRUE within-landmark correlation are used in calculation of correlation. Only used if landmark.dim is passed, default is FALSE.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach back-end must be registered, like doParallel or doMC.}
}
\value{
Returns a vector with the matrix correlation, significance via Mantel, within- and between module correlation.
}
\description{
Calculates the correlation and Mantel significance test between a hypothetical binary modularity
matrix and a correlation matrix. Also gives mean correlation within- and between-modules. 
This function is usually only called by TestModularity.
}
\details{
CalcAVG can be used when a significance test is not required.
}
\examples{
# Create a single modularity hypothesis:
hypot = rep(c(1, 0), each = 6)
cor.hypot = CreateHypotMatrix(hypot)

# First with an unstructured matrix:
un.cor = RandomMatrix(12)
MantelModTest(cor.hypot, un.cor)

# Now with a modular matrix:
hypot.mask = matrix(as.logical(cor.hypot), 12, 12)
mod.cor = matrix(NA, 12, 12)
mod.cor[ hypot.mask] = runif(length(mod.cor[ hypot.mask]), 0.8, 0.9) # within-modules
mod.cor[!hypot.mask] = runif(length(mod.cor[!hypot.mask]), 0.3, 0.4) # between-modules
diag(mod.cor) = 1
mod.cor = (mod.cor + t(mod.cor))/2 # correlation matrices should be symmetric

MantelModTest(cor.hypot, mod.cor)
}
\references{
Porto, Arthur, Felipe B. Oliveira, Leila T. Shirai, Valderes Conto, and Gabriel Marroig. 2009. "The Evolution of Modularity in the Mammalian Skull I: Morphological Integration Patterns and Magnitudes." Evolutionary Biology 36 (1): 118-35. doi:10.1007/s11692-008-9038-3.

Modularity and Morphometrics: Error Rates in Hypothesis Testing Guilherme Garcia, Felipe Bandoni de Oliveira, Gabriel Marroig bioRxiv 030874; doi: http://dx.doi.org/10.1101/030874
}
\seealso{
\code{\link[vegan]{mantel}},\code{\link{MantelCor}},\code{\link{CalcAVG}},\code{\link{TestModularity}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{manteltest}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}
