% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly.R
\name{hourly}
\alias{hourly}
\title{Calculate hourly mean, min or max}
\usage{
hourly(
  data,
  time = "date",
  var,
  stat = mean,
  min_offset = 30,
  numerical = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame with time column and variable columns to be processed}

\item{time}{name of the time column (default is date) in POSIXct}

\item{var}{name of the columns to be calculated}

\item{stat}{function of the statistics to calculate (default is mean)}

\item{min_offset}{minutes of observation from previous hour (default is 30)}

\item{numerical}{TRUE (default) includes only numerical columns}

\item{verbose}{display additional information}
}
\value{
data.frame including only numerical columns

data.frame with time and the hourly mean, min or max
}
\description{
function to calculate Ozone Maximum Daily 8-hr Average or 8-hr moving Average for a data.frame
}
\examples{
# in case there is connection issue
load_data <- function(cond) {
  message(paste("conection issue, loading pre-downloaded data"))
  DATA <- readRDS(paste0(system.file("extdata",package="eva3dm"),
                         "/riem_OAHR_jan_2012.Rds"))
  return(DATA)
}

sites <- c("OAHR")
for(site in sites){
  cat('Trying to download METAR from:',site,'...\n')
  DATA <- tryCatch(riem::riem_measures(station    = sites,
                                       date_start = "2012-01-01",
                                       date_end   = "2012-02-01"),
                   error = load_data)
}
data_hourly_mean <- hourly(DATA,time = 'valid')
data_hourly_min  <- hourly(DATA[1:7],time = 'valid',stat = min)
data_hourly_max  <- hourly(DATA[1:7],time = 'valid',stat = max)

}
