% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{db_type}
\alias{db_type}
\alias{db_type.src_dbi}
\alias{db_type.DBIConnection}
\title{Return the database type for an ETL or DBI connection}
\usage{
db_type(obj, ...)

\method{db_type}{src_dbi}(obj, ...)

\method{db_type}{DBIConnection}(obj, ...)
}
\arguments{
\item{obj}{and \link{etl} or \link[DBI:DBIConnection-class]{DBI::DBIConnection} object}

\item{...}{currently ignored}
}
\description{
Return the database type for an ETL or DBI connection
}
\examples{
if (require(RMariaDB) && mariadbHasDefault()) {
  # connect to test database using rs-dbi
  db <- src_mysql_cnf()
  class(db)
  db
  # connect to another server using the 'client' group
  db_type(db)
  db_type(db$con)
}
}
