% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{mean.errors}
\alias{mean.errors}
\alias{weighted.mean.errors}
\alias{median.errors}
\title{Arithmetic Mean and Median Value}
\usage{
\method{mean}{errors}(x, trim = 0, na.rm = FALSE, ...)

\method{weighted.mean}{errors}(x, ..., na.rm = FALSE)

\method{median}{errors}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{an \code{errors} object.}

\item{trim}{the fraction (0 to 0.5) of observations to be
    trimmed from each end of \code{x} before the mean is computed.
    Values of trim outside that range are taken as the nearest endpoint.
  }

\item{na.rm}{a logical evaluating to \code{TRUE} or \code{FALSE}
    indicating whether \code{NA} values should be stripped before the
    computation proceeds.}

\item{...}{further arguments passed to of from other methods.}
}
\value{
An \code{errors} object.
}
\description{
S3 methods for \code{errors} objects.
}
\details{
The \code{mean} and \code{weighted.mean} methods set the uncertainty as
the maximum of the standard deviation of the mean and the (weighted) mean of the uncertainty.

The \code{median} method sets the uncertainty as \code{1.253 * errors(mean(x))},
which is derived from the asymptotic variance formula of the median. Note that
this value is valid only if the sample is big enough.
}
