% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlebdm.R
\name{rlebdm}
\alias{rlebdm}
\alias{as.rlebdm}
\alias{as.rlebdm.matrix}
\alias{as.rlebdm.edgelist}
\alias{as.rlebdm.network}
\alias{as.matrix.rlebdm}
\alias{dim.rlebdm}
\alias{as.rle.rlebdm}
\alias{print.rlebdm}
\alias{Ops.rlebdm}
\alias{Math.rlebdm}
\alias{compress.rlebdm}
\alias{as.edgelist.rlebdm}
\title{RLE-Compressed Boolean Dyad Matrix}
\usage{
rlebdm(x, n)

as.rlebdm(x, ...)

\method{as.rlebdm}{matrix}(x, ...)

\method{as.rlebdm}{edgelist}(x, ...)

\method{as.rlebdm}{network}(x, ...)

\method{as.matrix}{rlebdm}(x, ...)

\method{dim}{rlebdm}(x)

\method{as.rle}{rlebdm}(x)

\method{print}{rlebdm}(x, compact = TRUE, ...)

\method{Ops}{rlebdm}(e1, e2)

\method{Math}{rlebdm}(x, ...)

\method{compress}{rlebdm}(x, ...)

\method{as.edgelist}{rlebdm}(x, prototype = NULL, ..., output = c("matrix", "tibble"))
}
\arguments{
\item{x}{for \code{\link[=rlebdm]{rlebdm()}}, an \code{\link[=rle]{rle()}} object or a vector that is converted to one; it will be coerced to \code{\link[=logical]{logical()}} before processing; for \code{\link[=as.rlebdm.matrix]{as.rlebdm.matrix()}}, a matrix.}

\item{n}{the dimensions of the square matrix represented.}

\item{...}{additional arguments, currently unused.}

\item{compact}{whether to print the matrix compactly (dots and stars) or to print it as a logical matrix.}

\item{e1, e2}{arguments to the unary (\code{e1}) or the binary (\code{e1} and \code{e2}) operators.}

\item{prototype}{an optional network with network attributes that
are transferred to the edgelist and will filter it (e.g., if the
prototype network is given and does not allow self-loops, the
edgelist will not have self-loops either,e ven if the dyad matrix
has non-\code{FALSE} diagonal).}

\item{output}{a string specifying whether the result should be a
matrix or a \code{\link[tibble:tibble]{tibble}}.}
}
\description{
A simple class representing boolean (logical) square matrix
run-length encoded in a column-major order.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.rle(rlebdm)}: Strip \code{rlebdm}-specific attributes and class, returning a plain \code{\link{rle}} object.

\item \code{compress(rlebdm)}: Compress the \code{rle} data structure in the
\code{rlebdm} by merging successive runs with identical values.

\item \code{as.edgelist(rlebdm)}: Convert an \code{\link{rlebdm}} object to an \code{\link[network:as.edgelist]{edgelist}}: a two-column
integer matrix or \code{\link[tibble:tibble]{tibble}} giving the cells with \code{TRUE} values.

}}
\section{Functions}{
\itemize{
\item \code{as.rlebdm(matrix)}: Convert a square matrix of mode coercible to \code{\link{logical}} to an
\code{\link{rlebdm}}.

\item \code{as.rlebdm(edgelist)}: Convert an object of class \code{\link[network:as.edgelist]{edgelist}} to an \code{\link{rlebdm}} object
whose cells in the edge list are set to \code{TRUE} and whose other
cells are set to \code{FALSE}.

\item \code{as.rlebdm(network)}: Convert an object of class \code{\link[network:network]{network}} to an \code{\link{rlebdm}} object
whose cells corresponding to extant edges are set to \code{TRUE} and
whose other cells are set to \code{FALSE}.

}}
\note{
The arithmetic operators are mathematical functions are
implemented for the \code{\link{Ops}} and the \code{\link{Math}} group generics and
therefore work for almost all of them automatically. To preserve
the integrity of the data structure, the results are cast to
logical before return.
}
\examples{
# From a vector
rlebdm(rep(rep(c(0,1),each=3),14)[seq_len(81)], 9)

# From a constant
rlebdm(1, 3)

# Large matrix (overflowing .Machine$integer.max)
big <- rlebdm(1, 50000)
unclass(big) # Represented as two runs
big # Only summary is printed
stopifnot(length(big)==50000^2)

}
\seealso{
\code{\link[=as.rlebdm.ergm_conlist]{as.rlebdm.ergm_conlist()}}

\code{\link[network:as.edgelist]{as.edgelist()}}
}
\keyword{internal}
