% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R
\name{ergm_propagate_ext.encode}
\alias{ergm_propagate_ext.encode}
\alias{ergm_no_ext.encode}
\title{Extended states for submodels}
\usage{
ergm_propagate_ext.encode(submodel)

ergm_no_ext.encode(submodel)
}
\arguments{
\item{submodel}{the \code{\link{ergm_model}} to which the encoders should be
propagated.}
}
\value{
\code{ergm_propagate_ext.encode} returns a list with one
element, \code{ext.encode} containing a function that follows the
extended state encoder API and simply returns a list of the
subterms extended state encodings.
}
\description{
\code{ergm_propagate_ext.encode()} is a convenience
function to propagate the extended state encoder to submodels if
they have any.

\code{ergm_no_ext.encode()} checks if a submodel contains
terms that use extended states and stops with an informative
error message if any do.
}
\note{
\code{ergm_propagate_ext.encode} should only be used when the
operator term does not modify the network and provides an
\code{x_function} on the C level that does appropriate propagation and
handles any return values.
}
\examples{
\dontrun{
# Typical usage:
InitErgmTerm.ABC <- function(nw, arglist, ...){
  [... implementation ...]
  m <- ergm_model([... etc. ...])
  c(list(name = "abc", inputs=1:3, submodel=m),
    ergm_propagate_ext.encode(m),
    wrap.ergm_model(nw, m)
  )
}
}

}
\keyword{internal}
