% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSIRD.R
\name{ModelSIRD}
\alias{ModelSIRD}
\alias{epiworld_sird}
\title{SIRD model}
\usage{
ModelSIRD(name, prevalence, transmission_rate, recovery_rate, death_rate)
}
\arguments{
\item{name}{String. Name of the virus}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Rate of recovery_rate from virus.}

\item{death_rate}{Numeric scalar between 0 and 1. Rate of death from virus.}
}
\value{
\itemize{
\item The \code{ModelSIRD} function returns a model of class \link{epiworld_model}.
}
}
\description{
SIRD model
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. The user must provide a vector of proportions indicating the following
values: (1) proportion of non-infected agents already removed, and (2) proportion of
non-ifected agents already deceased.
}
\examples{
model_sird <- ModelSIRD(
  name              = "COVID-19",
  prevalence        = 0.01,
  transmission_rate = 0.9,
  recovery_rate     = 0.1,
  death_rate        = 0.01
)

# Adding a small world population
agents_smallworld(
  model_sird,
  n = 1000,
  k = 5,
  d = FALSE,
  p = .01
)

# Running and printing
run(model_sird, ndays = 100, seed = 1912)
model_sird

# Plotting
plot(model_sird)
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelMeaslesQuarantine}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
