% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveAttrDefLabelGroup}
\alias{AddListRemoveAttrDefLabelGroup}
\alias{add_attrDefLabelGroup}
\alias{list_attrDefLabelGroups}
\alias{remove_attrDefLabelGroup}
\title{Add / List / Remove labelGroup to / of / from attributeDefinition of emuDB}
\usage{
add_attrDefLabelGroup(
  emuDBhandle,
  levelName,
  attributeDefinitionName,
  labelGroupName,
  labelGroupValues
)

list_attrDefLabelGroups(emuDBhandle, levelName, attributeDefinitionName)

remove_attrDefLabelGroup(
  emuDBhandle,
  levelName,
  attributeDefinitionName,
  labelGroupName
)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{levelName}{name of level}

\item{attributeDefinitionName}{name of attributeDefinition}

\item{labelGroupName}{name of label group}

\item{labelGroupValues}{character vector of labels}
}
\description{
Add / List / Remove label group to / of / from a specific attribute definition. 
This label group can be used as a short hand  
to reference groups of labels specific
to an attribute definition (compared to global label groups that 
are added by \code{\link{add_labelGroup}}) in a 
\code{\link{query}}. A common example would be to
add a label group for something like the phonetic
category of nasals to be able reference them 
as "nasals" in a \code{\link{query}}. For more information 
on the structural elements of an emuDB see \code{vignette(emuDB)}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

sampaNasals = c("m", "F", "n", "J", "N")

# add these values to the default Phonetic attribute
# definition of the Phonetic level of the ae emuDB
add_attrDefLabelGroup(emuDBhandle = ae,
                      levelName = "Phonetic",
                      attributeDefinitionName = "Phonetic",
                      labelGroupName = "sampaNasals",
                      labelGroupValues = sampaNasals)

# query the labelGroup
query(ae, "Phonetic=sampaNasals")


# list attribute definition label groups
# of attributeDefinition "Phonetic" of the level "Phonetic"
# of the ae emuDB
list_attrDefLabelGroups(emuDBhandle = ae, 
                        levelName = "Phonetic" , 
                        attributeDefinitionName = "Phonetic")

# remove the newly added attrDefLabelGroup
remove_attrDefLabelGroup(emuDBhandle = ae,
                         levelName = "Phonetic",
                         attributeDefinitionName = "Phonetic",
                         labelGroupName = "sampaNasals")

}

}
\seealso{
add_labelGroup
}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}
