% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hspec.R
\docType{class}
\name{hspec-class}
\alias{hspec-class}
\title{An S4 Class Representing an Exponential Marked Hawkes Model}
\description{
This class defines a marked Hawkes model with an exponential kernel.
The intensity of the ground process is expressed as:
\deqn{\lambda(t) = \mu + \int_{(-\infty,t)\times E} ( \alpha + g(u, z) )  e^{-\beta (t-u)} M(du \times dz).}
For more details, refer to the vignettes.
}
\details{
\eqn{\mu} is base intensity, typically a constant vector or a function.

\eqn{\alpha} is a constant matrix representing the impact on intensities after events, stored in the \code{alpha} slot.

\eqn{\beta} is a constant matrix for exponential decay rates, stored in the \code{beta} slot.

\eqn{z} represents the mark and can be generated by \code{rmark} slot.

\eqn{g} is represented by \code{eta} when it is linear function of \eqn{z}, and by \code{impact} when it is a genenral function.

\code{mu}, \code{alpha} and \code{beta} are required slots for every exponential Hawkes model.
\code{rmark} and \code{impact} are additional slots.
}
\section{Slots}{

\describe{
\item{\code{mu}}{A numeric value, matrix, or function. If numeric, it is automatically converted to a matrix.}

\item{\code{alpha}}{A numeric value, matrix, or function. If numeric, it is automatically converted to a matrix, representing the exciting term.}

\item{\code{beta}}{A numeric value, matrix, or function. If numeric, it is automatically converted to a matrix, representing the exponential decay.}

\item{\code{eta}}{A numeric value, matrix, or function. If numeric, it is automatically converted to a matrix, representing the impact of an additional mark.}

\item{\code{impact}}{A function describing the after-effects of the mark on \eqn{\lambda}, with the first argument always being \code{param}.}

\item{\code{dimens}}{The dimension of the model.}

\item{\code{rmark}}{A function that generates marks for the counting process, used in simulations.}

\item{\code{dmark}}{A density function for the mark, used in estimation.}

\item{\code{type_col_map}}{A mapping between type and column number of the kernel used in multi-kernel models.}

\item{\code{rresidual}}{A function for generating residuals, analogous to the R random number generator function, specifically for the discrete Hawkes model.}

\item{\code{dresidual}}{A density function for the residual.}

\item{\code{presidual}}{A distribution function for the residual.}

\item{\code{qresidual}}{A quantile function for the residual.}
}}

\examples{
MU <- matrix(c(0.2), nrow = 2)
ALPHA <- matrix(c(0.75, 0.92, 0.92, 0.75), nrow = 2, byrow=TRUE)
BETA <- matrix(c(2.25, 2.25, 2.25, 2.25), nrow = 2, byrow=TRUE)
mhspec2 <- new("hspec", mu=MU, alpha=ALPHA, beta=BETA)
mhspec2

}
