% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Type}
\alias{Type}
\alias{TypeBasic}
\alias{TypeEnum}
\alias{TypeArray}
\alias{TypeJsonSchema}
\alias{TypeObject}
\title{Type definitions for function calling and structured data extraction.}
\usage{
TypeBasic(description = NULL, required = TRUE, type = stop("Required"))

TypeEnum(description = NULL, required = TRUE, values = character(0))

TypeArray(description = NULL, required = TRUE, items = Type())

TypeJsonSchema(description = NULL, required = TRUE, json = list())

TypeObject(
  description = NULL,
  required = TRUE,
  properties = list(),
  additional_properties = FALSE
)
}
\arguments{
\item{description}{The purpose of the component. This is
used by the LLM to determine what values to pass to the tool or what
values to extract in the structured data, so the more detail that you can
provide here, the better.}

\item{required}{Is the component or argument required?

In type descriptions for structured data, if \code{required = FALSE} and the
component does not exist in the data, the LLM may hallucinate a value. Only
applies when the element is nested inside of a \code{type_object()}.

In tool definitions, \code{required = TRUE} signals that the LLM should always
provide a value. Arguments with \code{required = FALSE} should have a default
value in the tool function's definition. If the LLM does not provide a
value, the default value will be used.}

\item{type}{Basic type name. Must be one of \code{boolean}, \code{integer},
\code{number}, or \code{string}.}

\item{values}{Character vector of permitted values.}

\item{items}{The type of the array items. Can be created by any of the
\code{type_} function.}

\item{json}{A JSON schema object as a list.}

\item{properties}{Named list of properties stored inside the object.
Each element should be an S7 \code{Type} object.`}

\item{additional_properties}{Can the object have arbitrary additional
properties that are not explicitly listed? Only supported by Claude.}
}
\value{
S7 objects inheriting from \code{Type}
}
\description{
These S7 classes are provided for use by package devlopers who are
extending ellmer. In every day use, use \code{\link[=type_boolean]{type_boolean()}} and friends.
}
\examples{
TypeBasic(type = "boolean")
TypeArray(items = TypeBasic(type = "boolean"))
}
