% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proficiency_tools.R
\name{crosstabplot}
\alias{crosstabplot}
\title{Draw a visual crosstab (mosaic plot) with shading for correlations 
and labels in each cell.}
\usage{
crosstabplot(
  data,
  rowvar,
  colvar,
  varnames,
  title = NULL,
  subtitle = NULL,
  label = FALSE,
  shade = TRUE,
  ...
)
}
\arguments{
\item{data}{a data object, matrix or dataframe, that contains the categorical 
variables to compose the crosstab}

\item{rowvar}{a character value for the column in data that will be displayed on the rows
of the crosstab}

\item{colvar}{a character value for the column in data that will be displayed in columns of the 
crosstab}

\item{varnames}{a character vector of length two with the labels for rowvar and colvar
respectively}

\item{title}{a character vector of length one that contains the main title for the plot}

\item{subtitle}{a character vector of length one that contains the subtitle displayed 
beneath the plot}

\item{label}{logical, if TRUE cells will be labeled, else they will not}

\item{shade}{logical, if TRUE cells will be shaded with Pearson residuals}

\item{...}{additional arguments to \code{\link{crosstabs}} e.g. digits}
}
\value{
A mosaic plot
}
\description{
Improves labeling of mosaic plots over \code{mosaic} from the vcd package
}
\examples{
df <- data.frame(cbind(x=seq(1,3,by=1), y=sample(LETTERS[6:8],60,replace=TRUE)),
fac=sample(LETTERS[1:4], 60, replace=TRUE))
varnames<-c('Quality','Grade')
myCT <- crosstabs(df, rowvar = "x",colvar = "fac", varnames = varnames, digits =2)
crosstabplot(df, rowvar = "x",colvar = "fac", varnames = varnames, 
title = 'My Plot', subtitle = 'Foo', label = FALSE, shade = TRUE, digits = 3)
}
\seealso{
\code{\link[vcd]{mosaic}} which this function wraps
 \code{\link{crosstabs}} which does the data manipulation for the crosstab
}
\keyword{crosstabs}
\keyword{mosaic}
\keyword{vcd}
