% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2dummies_complex.R
\name{fac2dummies_complex}
\alias{fac2dummies_complex}
\title{Transform a complex factor variable to dummy variables.}
\usage{
fac2dummies_complex(GADSdat, var)
}
\arguments{
\item{GADSdat}{A \code{data.frame} or \code{GADSdat} object.}

\item{var}{A character vector with the name of the factor variable.}
}
\value{
Returns a \code{GADSdat} containing the newly computed variables.
}
\description{
Convert a factor variable with complex factor levels (factor levels contain combinations of other factor levels) to dummy variables.
Dummy variables are coded \code{1} (\code{"yes"}) and \code{0} (\code{"no"}).
}
\details{
The basic functionality of this function is analogous to \code{\link{fac2dummies}}. However, the function expects factor levels to only go
to \code{9}. Higher numbers are treated as combinations of factor levels, for example \code{"13"} as \code{"1"} and \code{"3"}.
}
\examples{
## create an example GADSdat
df_fac <- data.frame(id = 1:6, fac = c("Opt a", "Opt c, Opt b", "Opt c",
"Opt b", "Opt a, Opt b", "Opt a, Opt b, Opt c"), stringsAsFactors = TRUE)
g_fac <- import_DF(df_fac)
g_fac <- recodeGADS(g_fac, varName = "fac", oldValues = c(1, 2, 3, 4, 5, 6),
                     newValues = c(1, 12, 123, 2, 3, 23))

## transform factor variable
fac2dummies_complex(g_fac, "fac")


}
